@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.aws.transfer.ConnectorArgs.builder
import com.pulumi.aws.transfer.kotlin.inputs.ConnectorAs2ConfigArgs
import com.pulumi.aws.transfer.kotlin.inputs.ConnectorAs2ConfigArgsBuilder
import com.pulumi.aws.transfer.kotlin.inputs.ConnectorSftpConfigArgs
import com.pulumi.aws.transfer.kotlin.inputs.ConnectorSftpConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a AWS Transfer AS2 Connector resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Connector;
 * import com.pulumi.aws.transfer.ConnectorArgs;
 * import com.pulumi.aws.transfer.inputs.ConnectorAs2ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connector("example", ConnectorArgs.builder()
 *             .accessRole(aws_iam_role.test().arn())
 *             .as2Config(ConnectorAs2ConfigArgs.builder()
 *                 .compression("DISABLED")
 *                 .encryptionAlgorithm("AWS128_CBC")
 *                 .messageSubject("For Connector")
 *                 .localProfileId(aws_transfer_profile.local().profile_id())
 *                 .mdnResponse("NONE")
 *                 .mdnSigningAlgorithm("NONE")
 *                 .partnerProfileId(aws_transfer_profile.partner().profile_id())
 *                 .signingAlgorithm("NONE")
 *                 .build())
 *             .url("http://www.test.com")
 *             .build());
 *     }
 * }
 * ```
 * ### SFTP Connector
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Connector;
 * import com.pulumi.aws.transfer.ConnectorArgs;
 * import com.pulumi.aws.transfer.inputs.ConnectorSftpConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connector("example", ConnectorArgs.builder()
 *             .accessRole(aws_iam_role.test().arn())
 *             .sftpConfig(ConnectorSftpConfigArgs.builder()
 *                 .trustedHostKeys("ssh-rsa AAAAB3NYourKeysHere")
 *                 .userSecretId(aws_secretsmanager_secret.example().id())
 *                 .build())
 *             .url("sftp://test.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transfer AS2 Connector using the `connector_id`. For example:
 * ```sh
 *  $ pulumi import aws:transfer/connector:Connector example c-4221a88afd5f4362a
 * ```
 * @property accessRole The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
 * @property as2Config Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
 * @property loggingRole The IAM Role which is required for allowing the connector to turn on CloudWatch logging for Amazon S3 events.
 * @property sftpConfig Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property url The URL of the partners AS2 endpoint or SFTP endpoint.
 */
public data class ConnectorArgs(
    public val accessRole: Output<String>? = null,
    public val as2Config: Output<ConnectorAs2ConfigArgs>? = null,
    public val loggingRole: Output<String>? = null,
    public val sftpConfig: Output<ConnectorSftpConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val url: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.ConnectorArgs> {
    override fun toJava(): com.pulumi.aws.transfer.ConnectorArgs =
        com.pulumi.aws.transfer.ConnectorArgs.builder()
            .accessRole(accessRole?.applyValue({ args0 -> args0 }))
            .as2Config(as2Config?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .loggingRole(loggingRole?.applyValue({ args0 -> args0 }))
            .sftpConfig(sftpConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .url(url?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorArgs].
 */
@PulumiTagMarker
public class ConnectorArgsBuilder internal constructor() {
    private var accessRole: Output<String>? = null

    private var as2Config: Output<ConnectorAs2ConfigArgs>? = null

    private var loggingRole: Output<String>? = null

    private var sftpConfig: Output<ConnectorSftpConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var url: Output<String>? = null

    /**
     * @param value The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
     */
    @JvmName("pttfxdkyiydujeiv")
    public suspend fun accessRole(`value`: Output<String>) {
        this.accessRole = value
    }

    /**
     * @param value Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
     */
    @JvmName("bslrobjugtxwjfxs")
    public suspend fun as2Config(`value`: Output<ConnectorAs2ConfigArgs>) {
        this.as2Config = value
    }

    /**
     * @param value The IAM Role which is required for allowing the connector to turn on CloudWatch logging for Amazon S3 events.
     */
    @JvmName("tygfvawcepqornrq")
    public suspend fun loggingRole(`value`: Output<String>) {
        this.loggingRole = value
    }

    /**
     * @param value Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
     */
    @JvmName("stnfbcspbctlftmw")
    public suspend fun sftpConfig(`value`: Output<ConnectorSftpConfigArgs>) {
        this.sftpConfig = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jgjvqbejskepbpax")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The URL of the partners AS2 endpoint or SFTP endpoint.
     */
    @JvmName("rrmmovjywqbddaiw")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
     */
    @JvmName("aolriipojsybxdpq")
    public suspend fun accessRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessRole = mapped
    }

    /**
     * @param value Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
     */
    @JvmName("fgbpxpafmmeiivrr")
    public suspend fun as2Config(`value`: ConnectorAs2ConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.as2Config = mapped
    }

    /**
     * @param argument Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
     */
    @JvmName("eiukljqomqwdsvnh")
    public suspend fun as2Config(argument: suspend ConnectorAs2ConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorAs2ConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.as2Config = mapped
    }

    /**
     * @param value The IAM Role which is required for allowing the connector to turn on CloudWatch logging for Amazon S3 events.
     */
    @JvmName("dplaqcfsvjmhojkn")
    public suspend fun loggingRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingRole = mapped
    }

    /**
     * @param value Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
     */
    @JvmName("meipbnrbkhowvqtv")
    public suspend fun sftpConfig(`value`: ConnectorSftpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sftpConfig = mapped
    }

    /**
     * @param argument Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
     */
    @JvmName("jixwcybdcpabjvui")
    public suspend fun sftpConfig(argument: suspend ConnectorSftpConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectorSftpConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sftpConfig = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gwslxmvvafjtmwqg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tnigfcjciskctkex")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The URL of the partners AS2 endpoint or SFTP endpoint.
     */
    @JvmName("saqyngulwmavtyyd")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    internal fun build(): ConnectorArgs = ConnectorArgs(
        accessRole = accessRole,
        as2Config = as2Config,
        loggingRole = loggingRole,
        sftpConfig = sftpConfig,
        tags = tags,
        url = url,
    )
}
