@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.aws.transfer.ProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a AWS Transfer AS2 Profile resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Profile;
 * import com.pulumi.aws.transfer.ProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Profile("example", ProfileArgs.builder()
 *             .as2Id("example")
 *             .certificateIds(aws_transfer_certificate.example().certificate_id())
 *             .usage("LOCAL")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transfer AS2 Profile using the `profile_id`. For example:
 * ```sh
 *  $ pulumi import aws:transfer/profile:Profile example p-4221a88afd5f4362a
 * ```
 * @property as2Id The As2Id is the AS2 name as defined in the RFC 4130. For inbound ttransfers this is the AS2 From Header for the AS2 messages sent from the partner. For Outbound messages this is the AS2 To Header for the AS2 messages sent to the partner. his ID cannot include spaces.
 * @property certificateIds The list of certificate Ids from the imported certificate operation.
 * @property profileType The profile type should be LOCAL or PARTNER.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ProfileArgs(
    public val as2Id: Output<String>? = null,
    public val certificateIds: Output<List<String>>? = null,
    public val profileType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.ProfileArgs> {
    override fun toJava(): com.pulumi.aws.transfer.ProfileArgs =
        com.pulumi.aws.transfer.ProfileArgs.builder()
            .as2Id(as2Id?.applyValue({ args0 -> args0 }))
            .certificateIds(certificateIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .profileType(profileType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProfileArgs].
 */
@PulumiTagMarker
public class ProfileArgsBuilder internal constructor() {
    private var as2Id: Output<String>? = null

    private var certificateIds: Output<List<String>>? = null

    private var profileType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The As2Id is the AS2 name as defined in the RFC 4130. For inbound ttransfers this is the AS2 From Header for the AS2 messages sent from the partner. For Outbound messages this is the AS2 To Header for the AS2 messages sent to the partner. his ID cannot include spaces.
     */
    @JvmName("tuebpbhyehogmjfe")
    public suspend fun as2Id(`value`: Output<String>) {
        this.as2Id = value
    }

    /**
     * @param value The list of certificate Ids from the imported certificate operation.
     */
    @JvmName("okxsfsrghyjggxjr")
    public suspend fun certificateIds(`value`: Output<List<String>>) {
        this.certificateIds = value
    }

    @JvmName("ucxdkfcqtmfmxqkl")
    public suspend fun certificateIds(vararg values: Output<String>) {
        this.certificateIds = Output.all(values.asList())
    }

    /**
     * @param values The list of certificate Ids from the imported certificate operation.
     */
    @JvmName("sbvuntnfgltcauav")
    public suspend fun certificateIds(values: List<Output<String>>) {
        this.certificateIds = Output.all(values)
    }

    /**
     * @param value The profile type should be LOCAL or PARTNER.
     */
    @JvmName("jrfwchkboesumkkv")
    public suspend fun profileType(`value`: Output<String>) {
        this.profileType = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("irqhxvswashmbnrl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The As2Id is the AS2 name as defined in the RFC 4130. For inbound ttransfers this is the AS2 From Header for the AS2 messages sent from the partner. For Outbound messages this is the AS2 To Header for the AS2 messages sent to the partner. his ID cannot include spaces.
     */
    @JvmName("hvwdocvrcnvpdmjh")
    public suspend fun as2Id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.as2Id = mapped
    }

    /**
     * @param value The list of certificate Ids from the imported certificate operation.
     */
    @JvmName("gwaahehuhhudyudt")
    public suspend fun certificateIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateIds = mapped
    }

    /**
     * @param values The list of certificate Ids from the imported certificate operation.
     */
    @JvmName("ksrtyumsfwdpmkva")
    public suspend fun certificateIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateIds = mapped
    }

    /**
     * @param value The profile type should be LOCAL or PARTNER.
     */
    @JvmName("hqaspmkpgwnmadab")
    public suspend fun profileType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileType = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("chbbmnsdjovnksrn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("frwwbmxsmxpvdtfu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProfileArgs = ProfileArgs(
        as2Id = as2Id,
        certificateIds = certificateIds,
        profileType = profileType,
        tags = tags,
    )
}
