@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.aws.transfer.kotlin.outputs.ServerEndpointDetails
import com.pulumi.aws.transfer.kotlin.outputs.ServerProtocolDetails
import com.pulumi.aws.transfer.kotlin.outputs.ServerWorkflowDetails
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.transfer.kotlin.outputs.ServerEndpointDetails.Companion.toKotlin as serverEndpointDetailsToKotlin
import com.pulumi.aws.transfer.kotlin.outputs.ServerProtocolDetails.Companion.toKotlin as serverProtocolDetailsToKotlin
import com.pulumi.aws.transfer.kotlin.outputs.ServerWorkflowDetails.Companion.toKotlin as serverWorkflowDetailsToKotlin

/**
 * Builder for [Server].
 */
@PulumiTagMarker
public class ServerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerArgs = ServerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerArgsBuilder.() -> Unit) {
        val builder = ServerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Server {
        val builtJavaResource = com.pulumi.aws.transfer.Server(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Server(builtJavaResource)
    }
}

/**
 * Provides a AWS Transfer Server resource.
 * > **NOTE on AWS IAM permissions:** If the `endpoint_type` is set to `VPC`, the `ec2:DescribeVpcEndpoints` and `ec2:ModifyVpcEndpoint` [actions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonec2.html#amazonec2-actions-as-permissions) are used.
 * > **NOTE:** Use the `aws.transfer.Tag` resource to manage the system tags used for [custom hostnames](https://docs.aws.amazon.com/transfer/latest/userguide/requirements-dns.html#tag-custom-hostname-cdk).
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Server("example", ServerArgs.builder()
 *             .tags(Map.of("Name", "Example"))
 *             .build());
 *     }
 * }
 * ```
 * ### Security Policy Name
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Server("example", ServerArgs.builder()
 *             .securityPolicyName("TransferSecurityPolicy-2020-06")
 *             .build());
 *     }
 * }
 * ```
 * ### VPC Endpoint
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import com.pulumi.aws.transfer.inputs.ServerEndpointDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Server("example", ServerArgs.builder()
 *             .endpointType("VPC")
 *             .endpointDetails(ServerEndpointDetailsArgs.builder()
 *                 .addressAllocationIds(aws_eip.example().id())
 *                 .subnetIds(aws_subnet.example().id())
 *                 .vpcId(aws_vpc.example().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### AWS Directory authentication
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Server("example", ServerArgs.builder()
 *             .identityProviderType("AWS_DIRECTORY_SERVICE")
 *             .directoryId(aws_directory_service_directory.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### AWS Lambda authentication
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Server("example", ServerArgs.builder()
 *             .identityProviderType("AWS_LAMBDA")
 *             .function(aws_lambda_identity_provider.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Protocols
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import com.pulumi.aws.transfer.inputs.ServerEndpointDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Server("example", ServerArgs.builder()
 *             .endpointType("VPC")
 *             .endpointDetails(ServerEndpointDetailsArgs.builder()
 *                 .subnetIds(aws_subnet.example().id())
 *                 .vpcId(aws_vpc.example().id())
 *                 .build())
 *             .protocols(
 *                 "FTP",
 *                 "FTPS")
 *             .certificate(aws_acm_certificate.example().arn())
 *             .identityProviderType("API_GATEWAY")
 *             .url(String.format("%s%s", aws_api_gateway_deployment.example().invoke_url(),aws_api_gateway_resource.example().path()))
 *             .build());
 *     }
 * }
 * ```
 * ### Using Structured Logging Destinations
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var transferLogGroup = new LogGroup("transferLogGroup", LogGroupArgs.builder()
 *             .namePrefix("transfer_test_")
 *             .build());
 *         final var transferAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("transfer.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var iamForTransfer = new Role("iamForTransfer", RoleArgs.builder()
 *             .namePrefix("iam_for_transfer_")
 *             .assumeRolePolicy(transferAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .managedPolicyArns("arn:aws:iam::aws:policy/service-role/AWSTransferLoggingAccess")
 *             .build());
 *         var transferServer = new Server("transferServer", ServerArgs.builder()
 *             .endpointType("PUBLIC")
 *             .loggingRole(iamForTransfer.arn())
 *             .protocols("SFTP")
 *             .structuredLogDestinations(transferLogGroup.arn().applyValue(arn -> String.format("%s:*", arn)))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transfer Servers using the server `id`. For example:
 * ```sh
 *  $ pulumi import aws:transfer/server:Server example s-12345678
 * ```
 *  Certain resource arguments, such as `host_key`, cannot be read via the API and imported into the provider. This provider will display a difference for these arguments the first run after import if declared in the provider configuration for an imported resource.
 */
public class Server internal constructor(
    override val javaResource: com.pulumi.aws.transfer.Server,
) : KotlinCustomResource(javaResource, ServerMapper) {
    /**
     * Amazon Resource Name (ARN) of Transfer Server
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
     */
    public val certificate: Output<String>?
        get() = javaResource.certificate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
     */
    public val directoryId: Output<String>?
        get() = javaResource.directoryId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
     */
    public val domain: Output<String>?
        get() = javaResource.domain().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The endpoint of the Transfer Server (e.g., `s-12345678.server.transfer.REGION.amazonaws.com`)
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. Fields documented below.
     */
    public val endpointDetails: Output<ServerEndpointDetails>?
        get() = javaResource.endpointDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serverEndpointDetailsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn't accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
     */
    public val endpointType: Output<String>?
        get() = javaResource.endpointType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN for a lambda function to use for the Identity provider.
     */
    public val function: Output<String>?
        get() = javaResource.function().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N "" -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N "" -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N "" -f my-new-server-key` commands).
     */
    public val hostKey: Output<String>?
        get() = javaResource.hostKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * This value contains the message-digest algorithm (MD5) hash of the server's host key. This value is equivalent to the output of the `ssh-keygen -l -E md5 -f my-new-server-key` command.
     */
    public val hostKeyFingerprint: Output<String>
        get() = javaResource.hostKeyFingerprint().applyValue({ args0 -> args0 })

    /**
     * The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
     */
    public val identityProviderType: Output<String>?
        get() = javaResource.identityProviderType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
     */
    public val invocationRole: Output<String>?
        get() = javaResource.invocationRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
     */
    public val loggingRole: Output<String>?
        get() = javaResource.loggingRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
     */
    public val postAuthenticationLoginBanner: Output<String>?
        get() = javaResource.postAuthenticationLoginBanner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
     */
    public val preAuthenticationLoginBanner: Output<String>?
        get() = javaResource.preAuthenticationLoginBanner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The protocol settings that are configured for your server.
     */
    public val protocolDetails: Output<ServerProtocolDetails>
        get() = javaResource.protocolDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                serverProtocolDetailsToKotlin(args0)
            })
        })

    /**
     * Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This defaults to `SFTP` . The available protocols are:
     */
    public val protocols: Output<List<String>>
        get() = javaResource.protocols().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Specifies the name of the security policy that is attached to the server. Possible values are `TransferSecurityPolicy-2018-11`, `TransferSecurityPolicy-2020-06`, `TransferSecurityPolicy-FIPS-2020-06`, `TransferSecurityPolicy-2022-03` and `TransferSecurityPolicy-2023-05`. Default value is: `TransferSecurityPolicy-2018-11`.
     */
    public val securityPolicyName: Output<String>?
        get() = javaResource.securityPolicyName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
     */
    public val structuredLogDestinations: Output<List<String>>?
        get() = javaResource.structuredLogDestinations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
     */
    public val url: Output<String>?
        get() = javaResource.url().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the workflow details. See Workflow Details below.
     */
    public val workflowDetails: Output<ServerWorkflowDetails>?
        get() = javaResource.workflowDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serverWorkflowDetailsToKotlin(args0) })
            }).orElse(null)
        })
}

public object ServerMapper : ResourceMapper<Server> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.transfer.Server::class == javaResource::class

    override fun map(javaResource: Resource): Server = Server(
        javaResource as
            com.pulumi.aws.transfer.Server,
    )
}

/**
 * @see [Server].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Server].
 */
public suspend fun server(name: String, block: suspend ServerResourceBuilder.() -> Unit): Server {
    val builder = ServerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Server].
 * @param name The _unique_ name of the resulting resource.
 */
public fun server(name: String): Server {
    val builder = ServerResourceBuilder()
    builder.name(name)
    return builder.build()
}
