@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.aws.transfer.ServerArgs.builder
import com.pulumi.aws.transfer.kotlin.inputs.ServerEndpointDetailsArgs
import com.pulumi.aws.transfer.kotlin.inputs.ServerEndpointDetailsArgsBuilder
import com.pulumi.aws.transfer.kotlin.inputs.ServerProtocolDetailsArgs
import com.pulumi.aws.transfer.kotlin.inputs.ServerProtocolDetailsArgsBuilder
import com.pulumi.aws.transfer.kotlin.inputs.ServerWorkflowDetailsArgs
import com.pulumi.aws.transfer.kotlin.inputs.ServerWorkflowDetailsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a AWS Transfer Server resource.
 * > **NOTE on AWS IAM permissions:** If the `endpoint_type` is set to `VPC`, the `ec2:DescribeVpcEndpoints` and `ec2:ModifyVpcEndpoint` [actions](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonec2.html#amazonec2-actions-as-permissions) are used.
 * > **NOTE:** Use the `aws.transfer.Tag` resource to manage the system tags used for [custom hostnames](https://docs.aws.amazon.com/transfer/latest/userguide/requirements-dns.html#tag-custom-hostname-cdk).
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Server("example", ServerArgs.builder()
 *             .tags(Map.of("Name", "Example"))
 *             .build());
 *     }
 * }
 * ```
 * ### Security Policy Name
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Server("example", ServerArgs.builder()
 *             .securityPolicyName("TransferSecurityPolicy-2020-06")
 *             .build());
 *     }
 * }
 * ```
 * ### VPC Endpoint
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import com.pulumi.aws.transfer.inputs.ServerEndpointDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Server("example", ServerArgs.builder()
 *             .endpointType("VPC")
 *             .endpointDetails(ServerEndpointDetailsArgs.builder()
 *                 .addressAllocationIds(aws_eip.example().id())
 *                 .subnetIds(aws_subnet.example().id())
 *                 .vpcId(aws_vpc.example().id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### AWS Directory authentication
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Server("example", ServerArgs.builder()
 *             .identityProviderType("AWS_DIRECTORY_SERVICE")
 *             .directoryId(aws_directory_service_directory.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### AWS Lambda authentication
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Server("example", ServerArgs.builder()
 *             .identityProviderType("AWS_LAMBDA")
 *             .function(aws_lambda_identity_provider.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ### Protocols
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import com.pulumi.aws.transfer.inputs.ServerEndpointDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Server("example", ServerArgs.builder()
 *             .endpointType("VPC")
 *             .endpointDetails(ServerEndpointDetailsArgs.builder()
 *                 .subnetIds(aws_subnet.example().id())
 *                 .vpcId(aws_vpc.example().id())
 *                 .build())
 *             .protocols(
 *                 "FTP",
 *                 "FTPS")
 *             .certificate(aws_acm_certificate.example().arn())
 *             .identityProviderType("API_GATEWAY")
 *             .url(String.format("%s%s", aws_api_gateway_deployment.example().invoke_url(),aws_api_gateway_resource.example().path()))
 *             .build());
 *     }
 * }
 * ```
 * ### Using Structured Logging Destinations
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var transferLogGroup = new LogGroup("transferLogGroup", LogGroupArgs.builder()
 *             .namePrefix("transfer_test_")
 *             .build());
 *         final var transferAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("transfer.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var iamForTransfer = new Role("iamForTransfer", RoleArgs.builder()
 *             .namePrefix("iam_for_transfer_")
 *             .assumeRolePolicy(transferAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .managedPolicyArns("arn:aws:iam::aws:policy/service-role/AWSTransferLoggingAccess")
 *             .build());
 *         var transferServer = new Server("transferServer", ServerArgs.builder()
 *             .endpointType("PUBLIC")
 *             .loggingRole(iamForTransfer.arn())
 *             .protocols("SFTP")
 *             .structuredLogDestinations(transferLogGroup.arn().applyValue(arn -> String.format("%s:*", arn)))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transfer Servers using the server `id`. For example:
 * ```sh
 *  $ pulumi import aws:transfer/server:Server example s-12345678
 * ```
 *  Certain resource arguments, such as `host_key`, cannot be read via the API and imported into the provider. This provider will display a difference for these arguments the first run after import if declared in the provider configuration for an imported resource.
 * @property certificate The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
 * @property directoryId The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
 * @property domain The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
 * @property endpointDetails The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. Fields documented below.
 * @property endpointType The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn't accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
 * @property forceDestroy A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
 * @property function The ARN for a lambda function to use for the Identity provider.
 * @property hostKey RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N "" -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N "" -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N "" -f my-new-server-key` commands).
 * @property identityProviderType The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
 * @property invocationRole Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
 * @property loggingRole Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
 * @property postAuthenticationLoginBanner Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
 * @property preAuthenticationLoginBanner Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
 * @property protocolDetails The protocol settings that are configured for your server.
 * @property protocols Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This defaults to `SFTP` . The available protocols are:
 * @property securityPolicyName Specifies the name of the security policy that is attached to the server. Possible values are `TransferSecurityPolicy-2018-11`, `TransferSecurityPolicy-2020-06`, `TransferSecurityPolicy-FIPS-2020-06`, `TransferSecurityPolicy-2022-03` and `TransferSecurityPolicy-2023-05`. Default value is: `TransferSecurityPolicy-2018-11`.
 * @property structuredLogDestinations A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property url URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
 * @property workflowDetails Specifies the workflow details. See Workflow Details below.
 */
public data class ServerArgs(
    public val certificate: Output<String>? = null,
    public val directoryId: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val endpointDetails: Output<ServerEndpointDetailsArgs>? = null,
    public val endpointType: Output<String>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val function: Output<String>? = null,
    public val hostKey: Output<String>? = null,
    public val identityProviderType: Output<String>? = null,
    public val invocationRole: Output<String>? = null,
    public val loggingRole: Output<String>? = null,
    public val postAuthenticationLoginBanner: Output<String>? = null,
    public val preAuthenticationLoginBanner: Output<String>? = null,
    public val protocolDetails: Output<ServerProtocolDetailsArgs>? = null,
    public val protocols: Output<List<String>>? = null,
    public val securityPolicyName: Output<String>? = null,
    public val structuredLogDestinations: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val url: Output<String>? = null,
    public val workflowDetails: Output<ServerWorkflowDetailsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.ServerArgs> {
    override fun toJava(): com.pulumi.aws.transfer.ServerArgs =
        com.pulumi.aws.transfer.ServerArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .endpointDetails(endpointDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endpointType(endpointType?.applyValue({ args0 -> args0 }))
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .function(function?.applyValue({ args0 -> args0 }))
            .hostKey(hostKey?.applyValue({ args0 -> args0 }))
            .identityProviderType(identityProviderType?.applyValue({ args0 -> args0 }))
            .invocationRole(invocationRole?.applyValue({ args0 -> args0 }))
            .loggingRole(loggingRole?.applyValue({ args0 -> args0 }))
            .postAuthenticationLoginBanner(postAuthenticationLoginBanner?.applyValue({ args0 -> args0 }))
            .preAuthenticationLoginBanner(preAuthenticationLoginBanner?.applyValue({ args0 -> args0 }))
            .protocolDetails(protocolDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protocols(protocols?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityPolicyName(securityPolicyName?.applyValue({ args0 -> args0 }))
            .structuredLogDestinations(
                structuredLogDestinations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .url(url?.applyValue({ args0 -> args0 }))
            .workflowDetails(
                workflowDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ServerArgs].
 */
@PulumiTagMarker
public class ServerArgsBuilder internal constructor() {
    private var certificate: Output<String>? = null

    private var directoryId: Output<String>? = null

    private var domain: Output<String>? = null

    private var endpointDetails: Output<ServerEndpointDetailsArgs>? = null

    private var endpointType: Output<String>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var function: Output<String>? = null

    private var hostKey: Output<String>? = null

    private var identityProviderType: Output<String>? = null

    private var invocationRole: Output<String>? = null

    private var loggingRole: Output<String>? = null

    private var postAuthenticationLoginBanner: Output<String>? = null

    private var preAuthenticationLoginBanner: Output<String>? = null

    private var protocolDetails: Output<ServerProtocolDetailsArgs>? = null

    private var protocols: Output<List<String>>? = null

    private var securityPolicyName: Output<String>? = null

    private var structuredLogDestinations: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var url: Output<String>? = null

    private var workflowDetails: Output<ServerWorkflowDetailsArgs>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
     */
    @JvmName("vphojkgmoyulbapc")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
     */
    @JvmName("argfnumprsmxvyoo")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
     */
    @JvmName("gilgrneqneicvreb")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. Fields documented below.
     */
    @JvmName("himtuqbsnhhmnjdf")
    public suspend fun endpointDetails(`value`: Output<ServerEndpointDetailsArgs>) {
        this.endpointDetails = value
    }

    /**
     * @param value The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn't accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
     */
    @JvmName("iikqwibbwbmsswld")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
     */
    @JvmName("lkjbvvxhgobvhbfm")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value The ARN for a lambda function to use for the Identity provider.
     */
    @JvmName("raiqdptujjrlvnrc")
    public suspend fun function(`value`: Output<String>) {
        this.function = value
    }

    /**
     * @param value RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N "" -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N "" -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N "" -f my-new-server-key` commands).
     */
    @JvmName("ykuplnufgdlpctnh")
    public suspend fun hostKey(`value`: Output<String>) {
        this.hostKey = value
    }

    /**
     * @param value The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
     */
    @JvmName("wgyjysutduvxcfsr")
    public suspend fun identityProviderType(`value`: Output<String>) {
        this.identityProviderType = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
     */
    @JvmName("fywoipcxftcckybp")
    public suspend fun invocationRole(`value`: Output<String>) {
        this.invocationRole = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
     */
    @JvmName("egtbjnbxpnbldnhs")
    public suspend fun loggingRole(`value`: Output<String>) {
        this.loggingRole = value
    }

    /**
     * @param value Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
     */
    @JvmName("tenxhorpqdelrqwh")
    public suspend fun postAuthenticationLoginBanner(`value`: Output<String>) {
        this.postAuthenticationLoginBanner = value
    }

    /**
     * @param value Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
     */
    @JvmName("gmwtokwcewtcgbbk")
    public suspend fun preAuthenticationLoginBanner(`value`: Output<String>) {
        this.preAuthenticationLoginBanner = value
    }

    /**
     * @param value The protocol settings that are configured for your server.
     */
    @JvmName("kirdwgmswrlijuep")
    public suspend fun protocolDetails(`value`: Output<ServerProtocolDetailsArgs>) {
        this.protocolDetails = value
    }

    /**
     * @param value Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This defaults to `SFTP` . The available protocols are:
     */
    @JvmName("afulghtvpnlqcvbv")
    public suspend fun protocols(`value`: Output<List<String>>) {
        this.protocols = value
    }

    @JvmName("hfcomowrogwtqfrm")
    public suspend fun protocols(vararg values: Output<String>) {
        this.protocols = Output.all(values.asList())
    }

    /**
     * @param values Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This defaults to `SFTP` . The available protocols are:
     */
    @JvmName("aclspxcuwpoajjqe")
    public suspend fun protocols(values: List<Output<String>>) {
        this.protocols = Output.all(values)
    }

    /**
     * @param value Specifies the name of the security policy that is attached to the server. Possible values are `TransferSecurityPolicy-2018-11`, `TransferSecurityPolicy-2020-06`, `TransferSecurityPolicy-FIPS-2020-06`, `TransferSecurityPolicy-2022-03` and `TransferSecurityPolicy-2023-05`. Default value is: `TransferSecurityPolicy-2018-11`.
     */
    @JvmName("qujpyoilushvcqcb")
    public suspend fun securityPolicyName(`value`: Output<String>) {
        this.securityPolicyName = value
    }

    /**
     * @param value A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
     */
    @JvmName("qegemihivnncqxmx")
    public suspend fun structuredLogDestinations(`value`: Output<List<String>>) {
        this.structuredLogDestinations = value
    }

    @JvmName("lsdxotqnrfnhcaap")
    public suspend fun structuredLogDestinations(vararg values: Output<String>) {
        this.structuredLogDestinations = Output.all(values.asList())
    }

    /**
     * @param values A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
     */
    @JvmName("ymmqfnblynaaieen")
    public suspend fun structuredLogDestinations(values: List<Output<String>>) {
        this.structuredLogDestinations = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("swcxjpsarhklpglc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
     */
    @JvmName("hslhweihagjskvha")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Specifies the workflow details. See Workflow Details below.
     */
    @JvmName("mpafnbjwcddamyqv")
    public suspend fun workflowDetails(`value`: Output<ServerWorkflowDetailsArgs>) {
        this.workflowDetails = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. This is required when `protocols` is set to `FTPS`
     */
    @JvmName("imwmhmuvagyejfti")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value The directory service ID of the directory service you want to connect to with an `identity_provider_type` of `AWS_DIRECTORY_SERVICE`.
     */
    @JvmName("gamutpnjchwvxmed")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value The domain of the storage system that is used for file transfers. Valid values are: `S3` and `EFS`. The default value is `S3`.
     */
    @JvmName("ustdbokhnwsbmdtv")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. Fields documented below.
     */
    @JvmName("nganlhnuobwkgvhf")
    public suspend fun endpointDetails(`value`: ServerEndpointDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointDetails = mapped
    }

    /**
     * @param argument The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server. Fields documented below.
     */
    @JvmName("dljlkvagarmqoypc")
    public suspend
    fun endpointDetails(argument: suspend ServerEndpointDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ServerEndpointDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endpointDetails = mapped
    }

    /**
     * @param value The type of endpoint that you want your SFTP server connect to. If you connect to a `VPC` (or `VPC_ENDPOINT`), your SFTP server isn't accessible over the public internet. If you want to connect your SFTP server via public internet, set `PUBLIC`.  Defaults to `PUBLIC`.
     */
    @JvmName("khkqvvfytcqfihba")
    public suspend fun endpointType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value A boolean that indicates all users associated with the server should be deleted so that the Server can be destroyed without error. The default value is `false`. This option only applies to servers configured with a `SERVICE_MANAGED` `identity_provider_type`.
     */
    @JvmName("wdyehgbnhxvmptiy")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value The ARN for a lambda function to use for the Identity provider.
     */
    @JvmName("ruqhlaphiapbkamv")
    public suspend fun function(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.function = mapped
    }

    /**
     * @param value RSA, ECDSA, or ED25519 private key (e.g., as generated by the `ssh-keygen -t rsa -b 2048 -N "" -m PEM -f my-new-server-key`, `ssh-keygen -t ecdsa -b 256 -N "" -m PEM -f my-new-server-key` or `ssh-keygen -t ed25519 -N "" -f my-new-server-key` commands).
     */
    @JvmName("tytqmrcwlchwhwea")
    public suspend fun hostKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostKey = mapped
    }

    /**
     * @param value The mode of authentication enabled for this service. The default value is `SERVICE_MANAGED`, which allows you to store and access SFTP user credentials within the service. `API_GATEWAY` indicates that user authentication requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your choice. Using `AWS_DIRECTORY_SERVICE` will allow for authentication against AWS Managed Active Directory or Microsoft Active Directory in your on-premises environment, or in AWS using AD Connectors. Use the `AWS_LAMBDA` value to directly use a Lambda function as your identity provider. If you choose this value, you must specify the ARN for the lambda function in the `function` argument.
     */
    @JvmName("jmnstfeeuuixbgpo")
    public suspend fun identityProviderType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProviderType = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM role used to authenticate the user account with an `identity_provider_type` of `API_GATEWAY`.
     */
    @JvmName("aucyopkklvaeuxxh")
    public suspend fun invocationRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invocationRole = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of an IAM role that allows the service to write your SFTP users’ activity to your Amazon CloudWatch logs for monitoring and auditing purposes.
     */
    @JvmName("xhgmwljnuobgsbnf")
    public suspend fun loggingRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingRole = mapped
    }

    /**
     * @param value Specify a string to display when users connect to a server. This string is displayed after the user authenticates. The SFTP protocol does not support post-authentication display banners.
     */
    @JvmName("llprmegkquxpvnfu")
    public suspend fun postAuthenticationLoginBanner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postAuthenticationLoginBanner = mapped
    }

    /**
     * @param value Specify a string to display when users connect to a server. This string is displayed before the user authenticates.
     */
    @JvmName("brhcgldpgtqsdnun")
    public suspend fun preAuthenticationLoginBanner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preAuthenticationLoginBanner = mapped
    }

    /**
     * @param value The protocol settings that are configured for your server.
     */
    @JvmName("yglnaxpyxytqnbck")
    public suspend fun protocolDetails(`value`: ServerProtocolDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolDetails = mapped
    }

    /**
     * @param argument The protocol settings that are configured for your server.
     */
    @JvmName("dlvqershxwggthps")
    public suspend
    fun protocolDetails(argument: suspend ServerProtocolDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ServerProtocolDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.protocolDetails = mapped
    }

    /**
     * @param value Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This defaults to `SFTP` . The available protocols are:
     */
    @JvmName("jhfpptdrusyihwvd")
    public suspend fun protocols(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param values Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. This defaults to `SFTP` . The available protocols are:
     */
    @JvmName("lhwlkgsnvdedlpgc")
    public suspend fun protocols(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param value Specifies the name of the security policy that is attached to the server. Possible values are `TransferSecurityPolicy-2018-11`, `TransferSecurityPolicy-2020-06`, `TransferSecurityPolicy-FIPS-2020-06`, `TransferSecurityPolicy-2022-03` and `TransferSecurityPolicy-2023-05`. Default value is: `TransferSecurityPolicy-2018-11`.
     */
    @JvmName("gutfdoewpckonqti")
    public suspend fun securityPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityPolicyName = mapped
    }

    /**
     * @param value A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
     */
    @JvmName("fdiajpdluqpxqwkn")
    public suspend fun structuredLogDestinations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.structuredLogDestinations = mapped
    }

    /**
     * @param values A set of ARNs of destinations that will receive structured logs from the transfer server such as CloudWatch Log Group ARNs. If provided this enables the transfer server to emit structured logs to the specified locations.
     */
    @JvmName("llqispbsvuogwdof")
    public suspend fun structuredLogDestinations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.structuredLogDestinations = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vithanojjutsafaa")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("suihpuxpcbmujgjk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value URL of the service endpoint used to authenticate users with an `identity_provider_type` of `API_GATEWAY`.
     */
    @JvmName("ryiearmqthbbnpor")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value Specifies the workflow details. See Workflow Details below.
     */
    @JvmName("wjdyyjjwpqixlrbn")
    public suspend fun workflowDetails(`value`: ServerWorkflowDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflowDetails = mapped
    }

    /**
     * @param argument Specifies the workflow details. See Workflow Details below.
     */
    @JvmName("edfdrcpjcmslslew")
    public suspend
    fun workflowDetails(argument: suspend ServerWorkflowDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ServerWorkflowDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.workflowDetails = mapped
    }

    internal fun build(): ServerArgs = ServerArgs(
        certificate = certificate,
        directoryId = directoryId,
        domain = domain,
        endpointDetails = endpointDetails,
        endpointType = endpointType,
        forceDestroy = forceDestroy,
        function = function,
        hostKey = hostKey,
        identityProviderType = identityProviderType,
        invocationRole = invocationRole,
        loggingRole = loggingRole,
        postAuthenticationLoginBanner = postAuthenticationLoginBanner,
        preAuthenticationLoginBanner = preAuthenticationLoginBanner,
        protocolDetails = protocolDetails,
        protocols = protocols,
        securityPolicyName = securityPolicyName,
        structuredLogDestinations = structuredLogDestinations,
        tags = tags,
        url = url,
        workflowDetails = workflowDetails,
    )
}
