@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SshKey].
 */
@PulumiTagMarker
public class SshKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SshKeyArgs = SshKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SshKeyArgsBuilder.() -> Unit) {
        val builder = SshKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SshKey {
        val builtJavaResource = com.pulumi.aws.transfer.SshKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SshKey(builtJavaResource)
    }
}

/**
 * Provides a AWS Transfer User SSH Key resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.transfer.User;
 * import com.pulumi.aws.transfer.UserArgs;
 * import com.pulumi.aws.transfer.SshKey;
 * import com.pulumi.aws.transfer.SshKeyArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleServer = new Server("exampleServer", ServerArgs.builder()
 *             .identityProviderType("SERVICE_MANAGED")
 *             .tags(Map.of("NAME", "tf-acc-test-transfer-server"))
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("transfer.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .serverId(exampleServer.id())
 *             .userName("tftestuser")
 *             .role(exampleRole.arn())
 *             .tags(Map.of("NAME", "tftestuser"))
 *             .build());
 *         var exampleSshKey = new SshKey("exampleSshKey", SshKeyArgs.builder()
 *             .serverId(exampleServer.id())
 *             .userName(exampleUser.userName())
 *             .body("... SSH key ...")
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("AllowFullAccesstoS3")
 *                 .effect("Allow")
 *                 .actions("s3:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.id())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transfer SSH Public Key using the `server_id` and `user_name` and `ssh_public_key_id` separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:transfer/sshKey:SshKey bar s-12345678/test-username/key-12345
 * ```
 *
 */
public class SshKey internal constructor(
    override val javaResource: com.pulumi.aws.transfer.SshKey,
) : KotlinCustomResource(javaResource, SshKeyMapper) {
    /**
     * The public key portion of an SSH key pair.
     */
    public val body: Output<String>
        get() = javaResource.body().applyValue({ args0 -> args0 })

    /**
     * The Server ID of the Transfer Server (e.g., `s-12345678`)
     */
    public val serverId: Output<String>
        get() = javaResource.serverId().applyValue({ args0 -> args0 })

    /**
     * The name of the user account that is assigned to one or more servers.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object SshKeyMapper : ResourceMapper<SshKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.transfer.SshKey::class == javaResource::class

    override fun map(javaResource: Resource): SshKey = SshKey(
        javaResource as
            com.pulumi.aws.transfer.SshKey,
    )
}

/**
 * @see [SshKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SshKey].
 */
public suspend fun sshKey(name: String, block: suspend SshKeyResourceBuilder.() -> Unit): SshKey {
    val builder = SshKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SshKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sshKey(name: String): SshKey {
    val builder = SshKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
