@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.aws.transfer.SshKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a AWS Transfer User SSH Key resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Server;
 * import com.pulumi.aws.transfer.ServerArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.transfer.User;
 * import com.pulumi.aws.transfer.UserArgs;
 * import com.pulumi.aws.transfer.SshKey;
 * import com.pulumi.aws.transfer.SshKeyArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleServer = new Server("exampleServer", ServerArgs.builder()
 *             .identityProviderType("SERVICE_MANAGED")
 *             .tags(Map.of("NAME", "tf-acc-test-transfer-server"))
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("transfer.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .serverId(exampleServer.id())
 *             .userName("tftestuser")
 *             .role(exampleRole.arn())
 *             .tags(Map.of("NAME", "tftestuser"))
 *             .build());
 *         var exampleSshKey = new SshKey("exampleSshKey", SshKeyArgs.builder()
 *             .serverId(exampleServer.id())
 *             .userName(exampleUser.userName())
 *             .body("... SSH key ...")
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("AllowFullAccesstoS3")
 *                 .effect("Allow")
 *                 .actions("s3:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.id())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transfer SSH Public Key using the `server_id` and `user_name` and `ssh_public_key_id` separated by `/`. For example:
 * ```sh
 *  $ pulumi import aws:transfer/sshKey:SshKey bar s-12345678/test-username/key-12345
 * ```
 * @property body The public key portion of an SSH key pair.
 * @property serverId The Server ID of the Transfer Server (e.g., `s-12345678`)
 * @property userName The name of the user account that is assigned to one or more servers.
 */
public data class SshKeyArgs(
    public val body: Output<String>? = null,
    public val serverId: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.SshKeyArgs> {
    override fun toJava(): com.pulumi.aws.transfer.SshKeyArgs =
        com.pulumi.aws.transfer.SshKeyArgs.builder()
            .body(body?.applyValue({ args0 -> args0 }))
            .serverId(serverId?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SshKeyArgs].
 */
@PulumiTagMarker
public class SshKeyArgsBuilder internal constructor() {
    private var body: Output<String>? = null

    private var serverId: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value The public key portion of an SSH key pair.
     */
    @JvmName("kwrkhxqjnckgehpf")
    public suspend fun body(`value`: Output<String>) {
        this.body = value
    }

    /**
     * @param value The Server ID of the Transfer Server (e.g., `s-12345678`)
     */
    @JvmName("dfyqnnpatajlforr")
    public suspend fun serverId(`value`: Output<String>) {
        this.serverId = value
    }

    /**
     * @param value The name of the user account that is assigned to one or more servers.
     */
    @JvmName("wlvvbkruencrfqjo")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value The public key portion of an SSH key pair.
     */
    @JvmName("jfqjpmrnwphjdilo")
    public suspend fun body(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param value The Server ID of the Transfer Server (e.g., `s-12345678`)
     */
    @JvmName("tbtdlkjqgdufriaa")
    public suspend fun serverId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverId = mapped
    }

    /**
     * @param value The name of the user account that is assigned to one or more servers.
     */
    @JvmName("gewxrfltjwlalwra")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): SshKeyArgs = SshKeyArgs(
        body = body,
        serverId = serverId,
        userName = userName,
    )
}
