@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.aws.transfer.TransferFunctions.getServerPlain
import com.pulumi.aws.transfer.kotlin.inputs.GetServerPlainArgs
import com.pulumi.aws.transfer.kotlin.inputs.GetServerPlainArgsBuilder
import com.pulumi.aws.transfer.kotlin.outputs.GetServerResult
import com.pulumi.aws.transfer.kotlin.outputs.GetServerResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object TransferFunctions {
    /**
     * Use this data source to get the ARN of an AWS Transfer Server for use in other
     * resources.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.transfer.TransferFunctions;
     * import com.pulumi.aws.transfer.inputs.GetServerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = TransferFunctions.getServer(GetServerArgs.builder()
     *             .serverId("s-1234567")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getServer.
     * @return A collection of values returned by getServer.
     */
    public suspend fun getServer(argument: GetServerPlainArgs): GetServerResult =
        toKotlin(getServerPlain(argument.toJava()).await())

    /**
     * @see [getServer].
     * @param serverId ID for an SFTP server.
     * @return A collection of values returned by getServer.
     */
    public suspend fun getServer(serverId: String): GetServerResult {
        val argument = GetServerPlainArgs(
            serverId = serverId,
        )
        return toKotlin(getServerPlain(argument.toJava()).await())
    }

    /**
     * @see [getServer].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;transfer&#46;kotlin&#46;inputs&#46;GetServerPlainArgs].
     * @return A collection of values returned by getServer.
     */
    public suspend fun getServer(argument: suspend GetServerPlainArgsBuilder.() -> Unit):
        GetServerResult {
        val builder = GetServerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getServerPlain(builtArgument.toJava()).await())
    }
}
