@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.aws.transfer.WorkflowArgs.builder
import com.pulumi.aws.transfer.kotlin.inputs.WorkflowOnExceptionStepArgs
import com.pulumi.aws.transfer.kotlin.inputs.WorkflowOnExceptionStepArgsBuilder
import com.pulumi.aws.transfer.kotlin.inputs.WorkflowStepArgs
import com.pulumi.aws.transfer.kotlin.inputs.WorkflowStepArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a AWS Transfer Workflow resource.
 * ## Example Usage
 * ### Basic single step example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Workflow;
 * import com.pulumi.aws.transfer.WorkflowArgs;
 * import com.pulumi.aws.transfer.inputs.WorkflowStepArgs;
 * import com.pulumi.aws.transfer.inputs.WorkflowStepDeleteStepDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workflow("example", WorkflowArgs.builder()
 *             .steps(WorkflowStepArgs.builder()
 *                 .deleteStepDetails(WorkflowStepDeleteStepDetailsArgs.builder()
 *                     .name("example")
 *                     .sourceFileLocation("${original.file}")
 *                     .build())
 *                 .type("DELETE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Multistep example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Workflow;
 * import com.pulumi.aws.transfer.WorkflowArgs;
 * import com.pulumi.aws.transfer.inputs.WorkflowStepArgs;
 * import com.pulumi.aws.transfer.inputs.WorkflowStepCustomStepDetailsArgs;
 * import com.pulumi.aws.transfer.inputs.WorkflowStepTagStepDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workflow("example", WorkflowArgs.builder()
 *             .steps(
 *                 WorkflowStepArgs.builder()
 *                     .customStepDetails(WorkflowStepCustomStepDetailsArgs.builder()
 *                         .name("example")
 *                         .sourceFileLocation("${original.file}")
 *                         .target(aws_lambda_function.example().arn())
 *                         .timeoutSeconds(60)
 *                         .build())
 *                     .type("CUSTOM")
 *                     .build(),
 *                 WorkflowStepArgs.builder()
 *                     .tagStepDetails(WorkflowStepTagStepDetailsArgs.builder()
 *                         .name("example")
 *                         .sourceFileLocation("${original.file}")
 *                         .tags(WorkflowStepTagStepDetailsTagArgs.builder()
 *                             .key("Name")
 *                             .value("Hello World")
 *                             .build())
 *                         .build())
 *                     .type("TAG")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transfer Workflows using the `worflow_id`. For example:
 * ```sh
 *  $ pulumi import aws:transfer/workflow:Workflow example example
 * ```
 * @property description A textual description for the workflow.
 * @property onExceptionSteps Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
 * @property steps Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class WorkflowArgs(
    public val description: Output<String>? = null,
    public val onExceptionSteps: Output<List<WorkflowOnExceptionStepArgs>>? = null,
    public val steps: Output<List<WorkflowStepArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.WorkflowArgs> {
    override fun toJava(): com.pulumi.aws.transfer.WorkflowArgs =
        com.pulumi.aws.transfer.WorkflowArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .onExceptionSteps(
                onExceptionSteps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .steps(steps?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [WorkflowArgs].
 */
@PulumiTagMarker
public class WorkflowArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var onExceptionSteps: Output<List<WorkflowOnExceptionStepArgs>>? = null

    private var steps: Output<List<WorkflowStepArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A textual description for the workflow.
     */
    @JvmName("kewomtkohugoprvd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
     */
    @JvmName("dkjcotcoytbfmjue")
    public suspend fun onExceptionSteps(`value`: Output<List<WorkflowOnExceptionStepArgs>>) {
        this.onExceptionSteps = value
    }

    @JvmName("ufjdxvbnupyhqngo")
    public suspend fun onExceptionSteps(vararg values: Output<WorkflowOnExceptionStepArgs>) {
        this.onExceptionSteps = Output.all(values.asList())
    }

    /**
     * @param values Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
     */
    @JvmName("towvbgudghkswkkt")
    public suspend fun onExceptionSteps(values: List<Output<WorkflowOnExceptionStepArgs>>) {
        this.onExceptionSteps = Output.all(values)
    }

    /**
     * @param value Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
     */
    @JvmName("ksxcodrvugddjwxj")
    public suspend fun steps(`value`: Output<List<WorkflowStepArgs>>) {
        this.steps = value
    }

    @JvmName("fdhcgowbgrcvrcse")
    public suspend fun steps(vararg values: Output<WorkflowStepArgs>) {
        this.steps = Output.all(values.asList())
    }

    /**
     * @param values Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
     */
    @JvmName("xrccasvunwitiywe")
    public suspend fun steps(values: List<Output<WorkflowStepArgs>>) {
        this.steps = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mlwdjrpwpqappyor")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A textual description for the workflow.
     */
    @JvmName("ubvqgbssuqytoyac")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
     */
    @JvmName("xlvtccneydebyrou")
    public suspend fun onExceptionSteps(`value`: List<WorkflowOnExceptionStepArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onExceptionSteps = mapped
    }

    /**
     * @param argument Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
     */
    @JvmName("esgelvqbjqyyhixe")
    public suspend
    fun onExceptionSteps(argument: List<suspend WorkflowOnExceptionStepArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkflowOnExceptionStepArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.onExceptionSteps = mapped
    }

    /**
     * @param argument Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
     */
    @JvmName("ogovfikwamhyyxvr")
    public suspend fun onExceptionSteps(
        vararg
        argument: suspend WorkflowOnExceptionStepArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WorkflowOnExceptionStepArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.onExceptionSteps = mapped
    }

    /**
     * @param argument Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
     */
    @JvmName("ddpxnixovupnyiuv")
    public suspend
    fun onExceptionSteps(argument: suspend WorkflowOnExceptionStepArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WorkflowOnExceptionStepArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.onExceptionSteps = mapped
    }

    /**
     * @param values Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
     */
    @JvmName("wgdqjveoodoxmert")
    public suspend fun onExceptionSteps(vararg values: WorkflowOnExceptionStepArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onExceptionSteps = mapped
    }

    /**
     * @param value Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
     */
    @JvmName("dhlnkbpcojvslgbk")
    public suspend fun steps(`value`: List<WorkflowStepArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.steps = mapped
    }

    /**
     * @param argument Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
     */
    @JvmName("otrbdwlnpjhioccj")
    public suspend fun steps(argument: List<suspend WorkflowStepArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkflowStepArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param argument Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
     */
    @JvmName("ipextcfklyexxktt")
    public suspend fun steps(vararg argument: suspend WorkflowStepArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WorkflowStepArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param argument Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
     */
    @JvmName("ehlfdphqfpbewsro")
    public suspend fun steps(argument: suspend WorkflowStepArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WorkflowStepArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param values Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
     */
    @JvmName("uyuekwblktdsyhig")
    public suspend fun steps(vararg values: WorkflowStepArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.steps = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gkrowelatsqurras")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aovdlvaphesjhygc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WorkflowArgs = WorkflowArgs(
        description = description,
        onExceptionSteps = onExceptionSteps,
        steps = steps,
        tags = tags,
    )
}
