@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.AccessHomeDirectoryMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property entry Represents an entry and a target.
 * @property target Represents the map target.
 */
public data class AccessHomeDirectoryMappingArgs(
    public val entry: Output<String>,
    public val target: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.AccessHomeDirectoryMappingArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.AccessHomeDirectoryMappingArgs =
        com.pulumi.aws.transfer.inputs.AccessHomeDirectoryMappingArgs.builder()
            .entry(entry.applyValue({ args0 -> args0 }))
            .target(target.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessHomeDirectoryMappingArgs].
 */
@PulumiTagMarker
public class AccessHomeDirectoryMappingArgsBuilder internal constructor() {
    private var entry: Output<String>? = null

    private var target: Output<String>? = null

    /**
     * @param value Represents an entry and a target.
     */
    @JvmName("vidwiespwclplxpo")
    public suspend fun entry(`value`: Output<String>) {
        this.entry = value
    }

    /**
     * @param value Represents the map target.
     */
    @JvmName("plhhrjaxrfsoeyys")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Represents an entry and a target.
     */
    @JvmName("hneewmlnybctckdx")
    public suspend fun entry(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entry = mapped
    }

    /**
     * @param value Represents the map target.
     */
    @JvmName("xiklrpsekrrkdveh")
    public suspend fun target(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): AccessHomeDirectoryMappingArgs = AccessHomeDirectoryMappingArgs(
        entry = entry ?: throw PulumiNullFieldException("entry"),
        target = target ?: throw PulumiNullFieldException("target"),
    )
}
