@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.ServerProtocolDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property as2Transports Indicates the transport method for the AS2 messages. Currently, only `HTTP` is supported.
 * @property passiveIp Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer.
 * @property setStatOption Use to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket. Valid values: `DEFAULT`, `ENABLE_NO_OP`.
 * @property tlsSessionResumptionMode A property used with Transfer Family servers that use the FTPS protocol. Provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. Valid values: `DISABLED`, `ENABLED`, `ENFORCED`.
 */
public data class ServerProtocolDetailsArgs(
    public val as2Transports: Output<List<String>>? = null,
    public val passiveIp: Output<String>? = null,
    public val setStatOption: Output<String>? = null,
    public val tlsSessionResumptionMode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.ServerProtocolDetailsArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.ServerProtocolDetailsArgs =
        com.pulumi.aws.transfer.inputs.ServerProtocolDetailsArgs.builder()
            .as2Transports(as2Transports?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .passiveIp(passiveIp?.applyValue({ args0 -> args0 }))
            .setStatOption(setStatOption?.applyValue({ args0 -> args0 }))
            .tlsSessionResumptionMode(tlsSessionResumptionMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerProtocolDetailsArgs].
 */
@PulumiTagMarker
public class ServerProtocolDetailsArgsBuilder internal constructor() {
    private var as2Transports: Output<List<String>>? = null

    private var passiveIp: Output<String>? = null

    private var setStatOption: Output<String>? = null

    private var tlsSessionResumptionMode: Output<String>? = null

    /**
     * @param value Indicates the transport method for the AS2 messages. Currently, only `HTTP` is supported.
     */
    @JvmName("juauhuacbtjrnwnn")
    public suspend fun as2Transports(`value`: Output<List<String>>) {
        this.as2Transports = value
    }

    @JvmName("addisojolkglwabb")
    public suspend fun as2Transports(vararg values: Output<String>) {
        this.as2Transports = Output.all(values.asList())
    }

    /**
     * @param values Indicates the transport method for the AS2 messages. Currently, only `HTTP` is supported.
     */
    @JvmName("qrsayyvrwvxxubjn")
    public suspend fun as2Transports(values: List<Output<String>>) {
        this.as2Transports = Output.all(values)
    }

    /**
     * @param value Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer.
     */
    @JvmName("kfecvvkhdurlkbsd")
    public suspend fun passiveIp(`value`: Output<String>) {
        this.passiveIp = value
    }

    /**
     * @param value Use to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket. Valid values: `DEFAULT`, `ENABLE_NO_OP`.
     */
    @JvmName("khnriflpxrtncoat")
    public suspend fun setStatOption(`value`: Output<String>) {
        this.setStatOption = value
    }

    /**
     * @param value A property used with Transfer Family servers that use the FTPS protocol. Provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. Valid values: `DISABLED`, `ENABLED`, `ENFORCED`.
     */
    @JvmName("ghahcksnknupujik")
    public suspend fun tlsSessionResumptionMode(`value`: Output<String>) {
        this.tlsSessionResumptionMode = value
    }

    /**
     * @param value Indicates the transport method for the AS2 messages. Currently, only `HTTP` is supported.
     */
    @JvmName("aylcaminnypvecna")
    public suspend fun as2Transports(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.as2Transports = mapped
    }

    /**
     * @param values Indicates the transport method for the AS2 messages. Currently, only `HTTP` is supported.
     */
    @JvmName("xpuxvaspgkxsekab")
    public suspend fun as2Transports(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.as2Transports = mapped
    }

    /**
     * @param value Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer.
     */
    @JvmName("ynqlqxpejubmleqe")
    public suspend fun passiveIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passiveIp = mapped
    }

    /**
     * @param value Use to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket. Valid values: `DEFAULT`, `ENABLE_NO_OP`.
     */
    @JvmName("moxlhlpwqtefwkxc")
    public suspend fun setStatOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.setStatOption = mapped
    }

    /**
     * @param value A property used with Transfer Family servers that use the FTPS protocol. Provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. Valid values: `DISABLED`, `ENABLED`, `ENFORCED`.
     */
    @JvmName("niyjxicxirmcpnlu")
    public suspend fun tlsSessionResumptionMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsSessionResumptionMode = mapped
    }

    internal fun build(): ServerProtocolDetailsArgs = ServerProtocolDetailsArgs(
        as2Transports = as2Transports,
        passiveIp = passiveIp,
        setStatOption = setStatOption,
        tlsSessionResumptionMode = tlsSessionResumptionMode,
    )
}
