@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.ServerWorkflowDetailsOnPartialUploadArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property executionRole Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources.
 * @property workflowId A unique identifier for the workflow.
 */
public data class ServerWorkflowDetailsOnPartialUploadArgs(
    public val executionRole: Output<String>,
    public val workflowId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.ServerWorkflowDetailsOnPartialUploadArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.ServerWorkflowDetailsOnPartialUploadArgs =
        com.pulumi.aws.transfer.inputs.ServerWorkflowDetailsOnPartialUploadArgs.builder()
            .executionRole(executionRole.applyValue({ args0 -> args0 }))
            .workflowId(workflowId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerWorkflowDetailsOnPartialUploadArgs].
 */
@PulumiTagMarker
public class ServerWorkflowDetailsOnPartialUploadArgsBuilder internal constructor() {
    private var executionRole: Output<String>? = null

    private var workflowId: Output<String>? = null

    /**
     * @param value Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources.
     */
    @JvmName("ltyisgvsobxjmamm")
    public suspend fun executionRole(`value`: Output<String>) {
        this.executionRole = value
    }

    /**
     * @param value A unique identifier for the workflow.
     */
    @JvmName("pgxjfrxbfncyprad")
    public suspend fun workflowId(`value`: Output<String>) {
        this.workflowId = value
    }

    /**
     * @param value Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources.
     */
    @JvmName("vxyywyfchgpjemcc")
    public suspend fun executionRole(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.executionRole = mapped
    }

    /**
     * @param value A unique identifier for the workflow.
     */
    @JvmName("pxkyrmqifmdrhhtq")
    public suspend fun workflowId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workflowId = mapped
    }

    internal fun build(): ServerWorkflowDetailsOnPartialUploadArgs =
        ServerWorkflowDetailsOnPartialUploadArgs(
            executionRole = executionRole ?: throw PulumiNullFieldException("executionRole"),
            workflowId = workflowId ?: throw PulumiNullFieldException("workflowId"),
        )
}
