@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.UserHomeDirectoryMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property entry Represents an entry and a target.
 * @property target Represents the map target.
 * The `Restricted` option is achieved using the following mapping:
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * ```
 * ```python
 * import pulumi
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * return await Deployment.RunAsync(() =>
 * {
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *     }
 * }
 * ```
 * ```yaml
 * {}
 * ```
 */
public data class UserHomeDirectoryMappingArgs(
    public val entry: Output<String>,
    public val target: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.UserHomeDirectoryMappingArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.UserHomeDirectoryMappingArgs =
        com.pulumi.aws.transfer.inputs.UserHomeDirectoryMappingArgs.builder()
            .entry(entry.applyValue({ args0 -> args0 }))
            .target(target.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserHomeDirectoryMappingArgs].
 */
@PulumiTagMarker
public class UserHomeDirectoryMappingArgsBuilder internal constructor() {
    private var entry: Output<String>? = null

    private var target: Output<String>? = null

    /**
     * @param value Represents an entry and a target.
     */
    @JvmName("inbrousuebaolpcc")
    public suspend fun entry(`value`: Output<String>) {
        this.entry = value
    }

    /**
     * @param value Represents the map target.
     * The `Restricted` option is achieved using the following mapping:
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("jdbyylmrfwlffyml")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Represents an entry and a target.
     */
    @JvmName("inaopjrujkoiwsnj")
    public suspend fun entry(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entry = mapped
    }

    /**
     * @param value Represents the map target.
     * The `Restricted` option is achieved using the following mapping:
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("qwgrsdgcyypytmrh")
    public suspend fun target(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): UserHomeDirectoryMappingArgs = UserHomeDirectoryMappingArgs(
        entry = entry ?: throw PulumiNullFieldException("entry"),
        target = target ?: throw PulumiNullFieldException("target"),
    )
}
