@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.UserPosixProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property gid The POSIX group ID used for all EFS operations by this user.
 * @property secondaryGids The secondary POSIX group IDs used for all EFS operations by this user.
 * @property uid The POSIX user ID used for all EFS operations by this user.
 */
public data class UserPosixProfileArgs(
    public val gid: Output<Int>,
    public val secondaryGids: Output<List<Int>>? = null,
    public val uid: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.UserPosixProfileArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.UserPosixProfileArgs =
        com.pulumi.aws.transfer.inputs.UserPosixProfileArgs.builder()
            .gid(gid.applyValue({ args0 -> args0 }))
            .secondaryGids(secondaryGids?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .uid(uid.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPosixProfileArgs].
 */
@PulumiTagMarker
public class UserPosixProfileArgsBuilder internal constructor() {
    private var gid: Output<Int>? = null

    private var secondaryGids: Output<List<Int>>? = null

    private var uid: Output<Int>? = null

    /**
     * @param value The POSIX group ID used for all EFS operations by this user.
     */
    @JvmName("vlukhlmvjfnufxvc")
    public suspend fun gid(`value`: Output<Int>) {
        this.gid = value
    }

    /**
     * @param value The secondary POSIX group IDs used for all EFS operations by this user.
     */
    @JvmName("fqkvecxfucdkhayg")
    public suspend fun secondaryGids(`value`: Output<List<Int>>) {
        this.secondaryGids = value
    }

    @JvmName("nalidebgvdvihxvo")
    public suspend fun secondaryGids(vararg values: Output<Int>) {
        this.secondaryGids = Output.all(values.asList())
    }

    /**
     * @param values The secondary POSIX group IDs used for all EFS operations by this user.
     */
    @JvmName("tatyirrwdukkomer")
    public suspend fun secondaryGids(values: List<Output<Int>>) {
        this.secondaryGids = Output.all(values)
    }

    /**
     * @param value The POSIX user ID used for all EFS operations by this user.
     */
    @JvmName("vvyymuvvhvouaxea")
    public suspend fun uid(`value`: Output<Int>) {
        this.uid = value
    }

    /**
     * @param value The POSIX group ID used for all EFS operations by this user.
     */
    @JvmName("ykhrbokogwabgyxq")
    public suspend fun gid(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gid = mapped
    }

    /**
     * @param value The secondary POSIX group IDs used for all EFS operations by this user.
     */
    @JvmName("aarownpfbsheigcq")
    public suspend fun secondaryGids(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryGids = mapped
    }

    /**
     * @param values The secondary POSIX group IDs used for all EFS operations by this user.
     */
    @JvmName("idmvqpckblkqyyqn")
    public suspend fun secondaryGids(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryGids = mapped
    }

    /**
     * @param value The POSIX user ID used for all EFS operations by this user.
     */
    @JvmName("brivwcaiqwyocerq")
    public suspend fun uid(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uid = mapped
    }

    internal fun build(): UserPosixProfileArgs = UserPosixProfileArgs(
        gid = gid ?: throw PulumiNullFieldException("gid"),
        secondaryGids = secondaryGids,
        uid = uid ?: throw PulumiNullFieldException("uid"),
    )
}
