@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property copyStepDetails Details for a step that performs a file copy. See Copy Step Details below.
 * @property customStepDetails Details for a step that invokes a lambda function.
 * @property decryptStepDetails Details for a step that decrypts the file.
 * @property deleteStepDetails Details for a step that deletes the file.
 * @property tagStepDetails Details for a step that creates one or more tags.
 * @property type The type of encryption used. Currently, this value must be `"PGP"`.
 */
public data class WorkflowOnExceptionStepArgs(
    public val copyStepDetails: Output<WorkflowOnExceptionStepCopyStepDetailsArgs>? = null,
    public val customStepDetails: Output<WorkflowOnExceptionStepCustomStepDetailsArgs>? = null,
    public val decryptStepDetails: Output<WorkflowOnExceptionStepDecryptStepDetailsArgs>? = null,
    public val deleteStepDetails: Output<WorkflowOnExceptionStepDeleteStepDetailsArgs>? = null,
    public val tagStepDetails: Output<WorkflowOnExceptionStepTagStepDetailsArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepArgs =
        com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepArgs.builder()
            .copyStepDetails(copyStepDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customStepDetails(customStepDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .decryptStepDetails(
                decryptStepDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deleteStepDetails(deleteStepDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tagStepDetails(tagStepDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowOnExceptionStepArgs].
 */
@PulumiTagMarker
public class WorkflowOnExceptionStepArgsBuilder internal constructor() {
    private var copyStepDetails: Output<WorkflowOnExceptionStepCopyStepDetailsArgs>? = null

    private var customStepDetails: Output<WorkflowOnExceptionStepCustomStepDetailsArgs>? = null

    private var decryptStepDetails: Output<WorkflowOnExceptionStepDecryptStepDetailsArgs>? = null

    private var deleteStepDetails: Output<WorkflowOnExceptionStepDeleteStepDetailsArgs>? = null

    private var tagStepDetails: Output<WorkflowOnExceptionStepTagStepDetailsArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Details for a step that performs a file copy. See Copy Step Details below.
     */
    @JvmName("hihhlwoiesrlxmia")
    public suspend fun copyStepDetails(`value`: Output<WorkflowOnExceptionStepCopyStepDetailsArgs>) {
        this.copyStepDetails = value
    }

    /**
     * @param value Details for a step that invokes a lambda function.
     */
    @JvmName("ldggshqidjxqsqgq")
    public suspend
    fun customStepDetails(`value`: Output<WorkflowOnExceptionStepCustomStepDetailsArgs>) {
        this.customStepDetails = value
    }

    /**
     * @param value Details for a step that decrypts the file.
     */
    @JvmName("gdcloleqydfdrjof")
    public suspend
    fun decryptStepDetails(`value`: Output<WorkflowOnExceptionStepDecryptStepDetailsArgs>) {
        this.decryptStepDetails = value
    }

    /**
     * @param value Details for a step that deletes the file.
     */
    @JvmName("mguiqwgpvioctrxg")
    public suspend
    fun deleteStepDetails(`value`: Output<WorkflowOnExceptionStepDeleteStepDetailsArgs>) {
        this.deleteStepDetails = value
    }

    /**
     * @param value Details for a step that creates one or more tags.
     */
    @JvmName("rraekcrhawhutkcd")
    public suspend fun tagStepDetails(`value`: Output<WorkflowOnExceptionStepTagStepDetailsArgs>) {
        this.tagStepDetails = value
    }

    /**
     * @param value The type of encryption used. Currently, this value must be `"PGP"`.
     */
    @JvmName("grtsvyebdjgivfmp")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Details for a step that performs a file copy. See Copy Step Details below.
     */
    @JvmName("omoudppydhpaobsl")
    public suspend fun copyStepDetails(`value`: WorkflowOnExceptionStepCopyStepDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyStepDetails = mapped
    }

    /**
     * @param argument Details for a step that performs a file copy. See Copy Step Details below.
     */
    @JvmName("fmohamqteqywmmwl")
    public suspend
    fun copyStepDetails(argument: suspend WorkflowOnExceptionStepCopyStepDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = WorkflowOnExceptionStepCopyStepDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.copyStepDetails = mapped
    }

    /**
     * @param value Details for a step that invokes a lambda function.
     */
    @JvmName("hsjehtghbijeasoc")
    public suspend fun customStepDetails(`value`: WorkflowOnExceptionStepCustomStepDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customStepDetails = mapped
    }

    /**
     * @param argument Details for a step that invokes a lambda function.
     */
    @JvmName("ubiragtkbxoorvud")
    public suspend
    fun customStepDetails(argument: suspend WorkflowOnExceptionStepCustomStepDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = WorkflowOnExceptionStepCustomStepDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customStepDetails = mapped
    }

    /**
     * @param value Details for a step that decrypts the file.
     */
    @JvmName("eukdqwfllwselnqb")
    public suspend fun decryptStepDetails(`value`: WorkflowOnExceptionStepDecryptStepDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.decryptStepDetails = mapped
    }

    /**
     * @param argument Details for a step that decrypts the file.
     */
    @JvmName("oafdsywrkdmwqknp")
    public suspend
    fun decryptStepDetails(argument: suspend WorkflowOnExceptionStepDecryptStepDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = WorkflowOnExceptionStepDecryptStepDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.decryptStepDetails = mapped
    }

    /**
     * @param value Details for a step that deletes the file.
     */
    @JvmName("hippulwjsiujklov")
    public suspend fun deleteStepDetails(`value`: WorkflowOnExceptionStepDeleteStepDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteStepDetails = mapped
    }

    /**
     * @param argument Details for a step that deletes the file.
     */
    @JvmName("kkiousiqvarcjxpo")
    public suspend
    fun deleteStepDetails(argument: suspend WorkflowOnExceptionStepDeleteStepDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = WorkflowOnExceptionStepDeleteStepDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deleteStepDetails = mapped
    }

    /**
     * @param value Details for a step that creates one or more tags.
     */
    @JvmName("jajtlyufbmnrjidx")
    public suspend fun tagStepDetails(`value`: WorkflowOnExceptionStepTagStepDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagStepDetails = mapped
    }

    /**
     * @param argument Details for a step that creates one or more tags.
     */
    @JvmName("csyfialugnnvmhxe")
    public suspend
    fun tagStepDetails(argument: suspend WorkflowOnExceptionStepTagStepDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = WorkflowOnExceptionStepTagStepDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tagStepDetails = mapped
    }

    /**
     * @param value The type of encryption used. Currently, this value must be `"PGP"`.
     */
    @JvmName("hqeymhiwstoihyjv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): WorkflowOnExceptionStepArgs = WorkflowOnExceptionStepArgs(
        copyStepDetails = copyStepDetails,
        customStepDetails = customStepDetails,
        decryptStepDetails = decryptStepDetails,
        deleteStepDetails = deleteStepDetails,
        tagStepDetails = tagStepDetails,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
