@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepCopyStepDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property destinationFileLocation Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
 * @property name The name of the step, used as an identifier.
 * @property overwriteExisting A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
 * @property sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
 */
public data class WorkflowOnExceptionStepCopyStepDetailsArgs(
    public val destinationFileLocation:
    Output<WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs>? = null,
    public val name: Output<String>? = null,
    public val overwriteExisting: Output<String>? = null,
    public val sourceFileLocation: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepCopyStepDetailsArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepCopyStepDetailsArgs =
        com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepCopyStepDetailsArgs.builder()
            .destinationFileLocation(
                destinationFileLocation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .overwriteExisting(overwriteExisting?.applyValue({ args0 -> args0 }))
            .sourceFileLocation(sourceFileLocation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowOnExceptionStepCopyStepDetailsArgs].
 */
@PulumiTagMarker
public class WorkflowOnExceptionStepCopyStepDetailsArgsBuilder internal constructor() {
    private var destinationFileLocation:
        Output<WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs>? = null

    private var name: Output<String>? = null

    private var overwriteExisting: Output<String>? = null

    private var sourceFileLocation: Output<String>? = null

    /**
     * @param value Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
     */
    @JvmName("qnyncjekflxkdkmk")
    public suspend
    fun destinationFileLocation(`value`: Output<WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs>) {
        this.destinationFileLocation = value
    }

    /**
     * @param value The name of the step, used as an identifier.
     */
    @JvmName("bomhrmfcxuklbmbm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
     */
    @JvmName("bqmtvpnocqnjkimd")
    public suspend fun overwriteExisting(`value`: Output<String>) {
        this.overwriteExisting = value
    }

    /**
     * @param value Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
     */
    @JvmName("kifrogwiypgfadfj")
    public suspend fun sourceFileLocation(`value`: Output<String>) {
        this.sourceFileLocation = value
    }

    /**
     * @param value Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
     */
    @JvmName("tvobmsyqgdnahhsq")
    public suspend
    fun destinationFileLocation(`value`: WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationFileLocation = mapped
    }

    /**
     * @param argument Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
     */
    @JvmName("mbpvmbnsklincumi")
    public suspend
    fun destinationFileLocation(argument: suspend WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgsBuilder.() -> Unit) {
        val toBeMapped =
            WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.destinationFileLocation = mapped
    }

    /**
     * @param value The name of the step, used as an identifier.
     */
    @JvmName("ujelmbbcqdoqgxkt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
     */
    @JvmName("jdhnfrbsbonqmjav")
    public suspend fun overwriteExisting(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overwriteExisting = mapped
    }

    /**
     * @param value Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
     */
    @JvmName("upfklqfieafqgqmn")
    public suspend fun sourceFileLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceFileLocation = mapped
    }

    internal fun build(): WorkflowOnExceptionStepCopyStepDetailsArgs =
        WorkflowOnExceptionStepCopyStepDetailsArgs(
            destinationFileLocation = destinationFileLocation,
            name = name,
            overwriteExisting = overwriteExisting,
            sourceFileLocation = sourceFileLocation,
        )
}
