@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property efsFileLocation Specifies the details for the EFS file being copied.
 * @property s3FileLocation Specifies the details for the S3 file being copied.
 */
public data class WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs(
    public val efsFileLocation:
    Output<WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs>? =
        null,
    public val s3FileLocation:
    Output<WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs> {
    override fun toJava():
        com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs =
        com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs.builder()
            .efsFileLocation(efsFileLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3FileLocation(
                s3FileLocation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs].
 */
@PulumiTagMarker
public class WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgsBuilder internal
constructor() {
    private var efsFileLocation:
        Output<WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs>? =
        null

    private var s3FileLocation:
        Output<WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs>? =
        null

    /**
     * @param value Specifies the details for the EFS file being copied.
     */
    @JvmName("xgsxxbvpsdpoecqi")
    public suspend
    fun efsFileLocation(`value`: Output<WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs>) {
        this.efsFileLocation = value
    }

    /**
     * @param value Specifies the details for the S3 file being copied.
     */
    @JvmName("fjxbdqmrjrfvxusj")
    public suspend
    fun s3FileLocation(`value`: Output<WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs>) {
        this.s3FileLocation = value
    }

    /**
     * @param value Specifies the details for the EFS file being copied.
     */
    @JvmName("wdepeynpixyldbfi")
    public suspend
    fun efsFileLocation(`value`: WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.efsFileLocation = mapped
    }

    /**
     * @param argument Specifies the details for the EFS file being copied.
     */
    @JvmName("arvwrogqueqdgarp")
    public suspend
    fun efsFileLocation(argument: suspend WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgsBuilder.() -> Unit) {
        val toBeMapped =
            WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.efsFileLocation = mapped
    }

    /**
     * @param value Specifies the details for the S3 file being copied.
     */
    @JvmName("nwdspyydsubocddp")
    public suspend
    fun s3FileLocation(`value`: WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3FileLocation = mapped
    }

    /**
     * @param argument Specifies the details for the S3 file being copied.
     */
    @JvmName("rbyqwldlsfwixnqn")
    public suspend
    fun s3FileLocation(argument: suspend WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgsBuilder.() -> Unit) {
        val toBeMapped =
            WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3FileLocation = mapped
    }

    internal fun build(): WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs =
        WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs(
            efsFileLocation = efsFileLocation,
            s3FileLocation = s3FileLocation,
        )
}
