@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepDeleteStepDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the step, used as an identifier.
 * @property sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
 */
public data class WorkflowOnExceptionStepDeleteStepDetailsArgs(
    public val name: Output<String>? = null,
    public val sourceFileLocation: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepDeleteStepDetailsArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepDeleteStepDetailsArgs =
        com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepDeleteStepDetailsArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .sourceFileLocation(sourceFileLocation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowOnExceptionStepDeleteStepDetailsArgs].
 */
@PulumiTagMarker
public class WorkflowOnExceptionStepDeleteStepDetailsArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sourceFileLocation: Output<String>? = null

    /**
     * @param value The name of the step, used as an identifier.
     */
    @JvmName("vodsqqqunnlyfved")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
     */
    @JvmName("ahaosiadjyekbycv")
    public suspend fun sourceFileLocation(`value`: Output<String>) {
        this.sourceFileLocation = value
    }

    /**
     * @param value The name of the step, used as an identifier.
     */
    @JvmName("rghvxewsjipduciy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
     */
    @JvmName("optggomumlwmbywg")
    public suspend fun sourceFileLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceFileLocation = mapped
    }

    internal fun build(): WorkflowOnExceptionStepDeleteStepDetailsArgs =
        WorkflowOnExceptionStepDeleteStepDetailsArgs(
            name = name,
            sourceFileLocation = sourceFileLocation,
        )
}
