@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepTagStepDetailsTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The name assigned to the tag that you create.
 * @property value The value that corresponds to the key.
 */
public data class WorkflowOnExceptionStepTagStepDetailsTagArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepTagStepDetailsTagArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepTagStepDetailsTagArgs =
        com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepTagStepDetailsTagArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowOnExceptionStepTagStepDetailsTagArgs].
 */
@PulumiTagMarker
public class WorkflowOnExceptionStepTagStepDetailsTagArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name assigned to the tag that you create.
     */
    @JvmName("lpodgyeqpyinhmxf")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value that corresponds to the key.
     */
    @JvmName("xbbfwynxbrcnaxly")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name assigned to the tag that you create.
     */
    @JvmName("sqtjwjxxrwogpbkr")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value that corresponds to the key.
     */
    @JvmName("wgbtnwvarudumetn")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): WorkflowOnExceptionStepTagStepDetailsTagArgs =
        WorkflowOnExceptionStepTagStepDetailsTagArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
