@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property copyStepDetails Details for a step that performs a file copy. See Copy Step Details below.
 * @property customStepDetails Details for a step that invokes a lambda function.
 * @property decryptStepDetails Details for a step that decrypts the file.
 * @property deleteStepDetails Details for a step that deletes the file.
 * @property tagStepDetails Details for a step that creates one or more tags.
 * @property type The type of encryption used. Currently, this value must be `"PGP"`.
 */
public data class WorkflowStepArgs(
    public val copyStepDetails: Output<WorkflowStepCopyStepDetailsArgs>? = null,
    public val customStepDetails: Output<WorkflowStepCustomStepDetailsArgs>? = null,
    public val decryptStepDetails: Output<WorkflowStepDecryptStepDetailsArgs>? = null,
    public val deleteStepDetails: Output<WorkflowStepDeleteStepDetailsArgs>? = null,
    public val tagStepDetails: Output<WorkflowStepTagStepDetailsArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowStepArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.WorkflowStepArgs =
        com.pulumi.aws.transfer.inputs.WorkflowStepArgs.builder()
            .copyStepDetails(copyStepDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customStepDetails(customStepDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .decryptStepDetails(
                decryptStepDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deleteStepDetails(deleteStepDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tagStepDetails(tagStepDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowStepArgs].
 */
@PulumiTagMarker
public class WorkflowStepArgsBuilder internal constructor() {
    private var copyStepDetails: Output<WorkflowStepCopyStepDetailsArgs>? = null

    private var customStepDetails: Output<WorkflowStepCustomStepDetailsArgs>? = null

    private var decryptStepDetails: Output<WorkflowStepDecryptStepDetailsArgs>? = null

    private var deleteStepDetails: Output<WorkflowStepDeleteStepDetailsArgs>? = null

    private var tagStepDetails: Output<WorkflowStepTagStepDetailsArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Details for a step that performs a file copy. See Copy Step Details below.
     */
    @JvmName("firocgvrqnkcrrhh")
    public suspend fun copyStepDetails(`value`: Output<WorkflowStepCopyStepDetailsArgs>) {
        this.copyStepDetails = value
    }

    /**
     * @param value Details for a step that invokes a lambda function.
     */
    @JvmName("ugntenyfqbjxxtse")
    public suspend fun customStepDetails(`value`: Output<WorkflowStepCustomStepDetailsArgs>) {
        this.customStepDetails = value
    }

    /**
     * @param value Details for a step that decrypts the file.
     */
    @JvmName("dggxjwpehdrougjd")
    public suspend fun decryptStepDetails(`value`: Output<WorkflowStepDecryptStepDetailsArgs>) {
        this.decryptStepDetails = value
    }

    /**
     * @param value Details for a step that deletes the file.
     */
    @JvmName("ognrcbvklvhjevtx")
    public suspend fun deleteStepDetails(`value`: Output<WorkflowStepDeleteStepDetailsArgs>) {
        this.deleteStepDetails = value
    }

    /**
     * @param value Details for a step that creates one or more tags.
     */
    @JvmName("cqnbmsytxpdjhjvl")
    public suspend fun tagStepDetails(`value`: Output<WorkflowStepTagStepDetailsArgs>) {
        this.tagStepDetails = value
    }

    /**
     * @param value The type of encryption used. Currently, this value must be `"PGP"`.
     */
    @JvmName("gjtuboijoqfytgmd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Details for a step that performs a file copy. See Copy Step Details below.
     */
    @JvmName("sksncepwktvrlaht")
    public suspend fun copyStepDetails(`value`: WorkflowStepCopyStepDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyStepDetails = mapped
    }

    /**
     * @param argument Details for a step that performs a file copy. See Copy Step Details below.
     */
    @JvmName("btkwvsrphlanhdso")
    public suspend
    fun copyStepDetails(argument: suspend WorkflowStepCopyStepDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = WorkflowStepCopyStepDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.copyStepDetails = mapped
    }

    /**
     * @param value Details for a step that invokes a lambda function.
     */
    @JvmName("xsnfmmxcjhnodfxd")
    public suspend fun customStepDetails(`value`: WorkflowStepCustomStepDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customStepDetails = mapped
    }

    /**
     * @param argument Details for a step that invokes a lambda function.
     */
    @JvmName("ygwtioqkfkyfgfhc")
    public suspend
    fun customStepDetails(argument: suspend WorkflowStepCustomStepDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = WorkflowStepCustomStepDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customStepDetails = mapped
    }

    /**
     * @param value Details for a step that decrypts the file.
     */
    @JvmName("iqwfidckxrxecxus")
    public suspend fun decryptStepDetails(`value`: WorkflowStepDecryptStepDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.decryptStepDetails = mapped
    }

    /**
     * @param argument Details for a step that decrypts the file.
     */
    @JvmName("kuyyiilvhtwymioy")
    public suspend
    fun decryptStepDetails(argument: suspend WorkflowStepDecryptStepDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = WorkflowStepDecryptStepDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.decryptStepDetails = mapped
    }

    /**
     * @param value Details for a step that deletes the file.
     */
    @JvmName("phvgckcprblpwbfr")
    public suspend fun deleteStepDetails(`value`: WorkflowStepDeleteStepDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteStepDetails = mapped
    }

    /**
     * @param argument Details for a step that deletes the file.
     */
    @JvmName("wtgpnpxtnivukklk")
    public suspend
    fun deleteStepDetails(argument: suspend WorkflowStepDeleteStepDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = WorkflowStepDeleteStepDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deleteStepDetails = mapped
    }

    /**
     * @param value Details for a step that creates one or more tags.
     */
    @JvmName("ecfytjyhvqmnficc")
    public suspend fun tagStepDetails(`value`: WorkflowStepTagStepDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagStepDetails = mapped
    }

    /**
     * @param argument Details for a step that creates one or more tags.
     */
    @JvmName("hsstkijvjkpdywhd")
    public suspend
    fun tagStepDetails(argument: suspend WorkflowStepTagStepDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = WorkflowStepTagStepDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tagStepDetails = mapped
    }

    /**
     * @param value The type of encryption used. Currently, this value must be `"PGP"`.
     */
    @JvmName("jcaewxclwxuirckb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): WorkflowStepArgs = WorkflowStepArgs(
        copyStepDetails = copyStepDetails,
        customStepDetails = customStepDetails,
        decryptStepDetails = decryptStepDetails,
        deleteStepDetails = deleteStepDetails,
        tagStepDetails = tagStepDetails,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
