@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowStepDecryptStepDetailsDestinationFileLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property efsFileLocation Specifies the details for the EFS file being copied.
 * @property s3FileLocation Specifies the details for the S3 file being copied.
 */
public data class WorkflowStepDecryptStepDetailsDestinationFileLocationArgs(
    public val efsFileLocation:
    Output<WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs>? = null,
    public val s3FileLocation:
    Output<WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowStepDecryptStepDetailsDestinationFileLocationArgs> {
    override fun toJava():
        com.pulumi.aws.transfer.inputs.WorkflowStepDecryptStepDetailsDestinationFileLocationArgs =
        com.pulumi.aws.transfer.inputs.WorkflowStepDecryptStepDetailsDestinationFileLocationArgs.builder()
            .efsFileLocation(efsFileLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3FileLocation(
                s3FileLocation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkflowStepDecryptStepDetailsDestinationFileLocationArgs].
 */
@PulumiTagMarker
public class WorkflowStepDecryptStepDetailsDestinationFileLocationArgsBuilder internal constructor() {
    private var efsFileLocation:
        Output<WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs>? = null

    private var s3FileLocation:
        Output<WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs>? = null

    /**
     * @param value Specifies the details for the EFS file being copied.
     */
    @JvmName("rjgghvwxpdbdnllm")
    public suspend
    fun efsFileLocation(`value`: Output<WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs>) {
        this.efsFileLocation = value
    }

    /**
     * @param value Specifies the details for the S3 file being copied.
     */
    @JvmName("dfbktnukenkbysto")
    public suspend
    fun s3FileLocation(`value`: Output<WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs>) {
        this.s3FileLocation = value
    }

    /**
     * @param value Specifies the details for the EFS file being copied.
     */
    @JvmName("mlblwigrdgypqprt")
    public suspend
    fun efsFileLocation(`value`: WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.efsFileLocation = mapped
    }

    /**
     * @param argument Specifies the details for the EFS file being copied.
     */
    @JvmName("ogxtgcvsldidqmwb")
    public suspend
    fun efsFileLocation(argument: suspend WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgsBuilder.() -> Unit) {
        val toBeMapped =
            WorkflowStepDecryptStepDetailsDestinationFileLocationEfsFileLocationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.efsFileLocation = mapped
    }

    /**
     * @param value Specifies the details for the S3 file being copied.
     */
    @JvmName("xmxyuleluhwokpno")
    public suspend
    fun s3FileLocation(`value`: WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3FileLocation = mapped
    }

    /**
     * @param argument Specifies the details for the S3 file being copied.
     */
    @JvmName("oeqjkakphcmwgcha")
    public suspend
    fun s3FileLocation(argument: suspend WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgsBuilder.() -> Unit) {
        val toBeMapped =
            WorkflowStepDecryptStepDetailsDestinationFileLocationS3FileLocationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3FileLocation = mapped
    }

    internal fun build(): WorkflowStepDecryptStepDetailsDestinationFileLocationArgs =
        WorkflowStepDecryptStepDetailsDestinationFileLocationArgs(
            efsFileLocation = efsFileLocation,
            s3FileLocation = s3FileLocation,
        )
}
