@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property onPartialUpload A trigger that starts a workflow if a file is only partially uploaded. See Workflow Detail below.
 * @property onUpload A trigger that starts a workflow: the workflow begins to execute after a file is uploaded. See Workflow Detail below.
 */
public data class ServerWorkflowDetails(
    public val onPartialUpload: ServerWorkflowDetailsOnPartialUpload? = null,
    public val onUpload: ServerWorkflowDetailsOnUpload? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.ServerWorkflowDetails):
            ServerWorkflowDetails = ServerWorkflowDetails(
            onPartialUpload = javaType.onPartialUpload().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.transfer.kotlin.outputs.ServerWorkflowDetailsOnPartialUpload.Companion.toKotlin(args0)
                })
            }).orElse(null),
            onUpload = javaType.onUpload().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.transfer.kotlin.outputs.ServerWorkflowDetailsOnUpload.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
