@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property entry Represents an entry and a target.
 * @property target Represents the map target.
 * The `Restricted` option is achieved using the following mapping:
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * ```
 * ```python
 * import pulumi
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * return await Deployment.RunAsync(() =>
 * {
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *     }
 * }
 * ```
 * ```yaml
 * {}
 * ```
 */
public data class UserHomeDirectoryMapping(
    public val entry: String,
    public val target: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.UserHomeDirectoryMapping):
            UserHomeDirectoryMapping = UserHomeDirectoryMapping(
            entry = javaType.entry(),
            target = javaType.target(),
        )
    }
}
