@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property gid The POSIX group ID used for all EFS operations by this user.
 * @property secondaryGids The secondary POSIX group IDs used for all EFS operations by this user.
 * @property uid The POSIX user ID used for all EFS operations by this user.
 */
public data class UserPosixProfile(
    public val gid: Int,
    public val secondaryGids: List<Int>? = null,
    public val uid: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.UserPosixProfile):
            UserPosixProfile = UserPosixProfile(
            gid = javaType.gid(),
            secondaryGids = javaType.secondaryGids().map({ args0 -> args0 }),
            uid = javaType.uid(),
        )
    }
}
