@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the step, used as an identifier.
 * @property sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
 * @property target The ARN for the lambda function that is being called.
 * @property timeoutSeconds Timeout, in seconds, for the step.
 */
public data class WorkflowOnExceptionStepCustomStepDetails(
    public val name: String? = null,
    public val sourceFileLocation: String? = null,
    public val target: String? = null,
    public val timeoutSeconds: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.WorkflowOnExceptionStepCustomStepDetails):
            WorkflowOnExceptionStepCustomStepDetails = WorkflowOnExceptionStepCustomStepDetails(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            sourceFileLocation = javaType.sourceFileLocation().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
            timeoutSeconds = javaType.timeoutSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
