@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property copyStepDetails Details for a step that performs a file copy. See Copy Step Details below.
 * @property customStepDetails Details for a step that invokes a lambda function.
 * @property decryptStepDetails Details for a step that decrypts the file.
 * @property deleteStepDetails Details for a step that deletes the file.
 * @property tagStepDetails Details for a step that creates one or more tags.
 * @property type The type of encryption used. Currently, this value must be `"PGP"`.
 */
public data class WorkflowStep(
    public val copyStepDetails: WorkflowStepCopyStepDetails? = null,
    public val customStepDetails: WorkflowStepCustomStepDetails? = null,
    public val decryptStepDetails: WorkflowStepDecryptStepDetails? = null,
    public val deleteStepDetails: WorkflowStepDeleteStepDetails? = null,
    public val tagStepDetails: WorkflowStepTagStepDetails? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.WorkflowStep): WorkflowStep =
            WorkflowStep(
                copyStepDetails = javaType.copyStepDetails().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.transfer.kotlin.outputs.WorkflowStepCopyStepDetails.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                customStepDetails = javaType.customStepDetails().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.transfer.kotlin.outputs.WorkflowStepCustomStepDetails.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                decryptStepDetails = javaType.decryptStepDetails().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.transfer.kotlin.outputs.WorkflowStepDecryptStepDetails.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                deleteStepDetails = javaType.deleteStepDetails().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.transfer.kotlin.outputs.WorkflowStepDeleteStepDetails.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                tagStepDetails = javaType.tagStepDetails().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.transfer.kotlin.outputs.WorkflowStepTagStepDetails.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                type = javaType.type(),
            )
    }
}
