@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destinationFileLocation Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
 * @property name The name of the step, used as an identifier.
 * @property overwriteExisting A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
 * @property sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
 * @property type The type of encryption used. Currently, this value must be `"PGP"`.
 */
public data class WorkflowStepDecryptStepDetails(
    public val destinationFileLocation: WorkflowStepDecryptStepDetailsDestinationFileLocation? = null,
    public val name: String? = null,
    public val overwriteExisting: String? = null,
    public val sourceFileLocation: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.WorkflowStepDecryptStepDetails):
            WorkflowStepDecryptStepDetails = WorkflowStepDecryptStepDetails(
            destinationFileLocation = javaType.destinationFileLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.transfer.kotlin.outputs.WorkflowStepDecryptStepDetailsDestinationFileLocation.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            overwriteExisting = javaType.overwriteExisting().map({ args0 -> args0 }).orElse(null),
            sourceFileLocation = javaType.sourceFileLocation().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
