@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the step, used as an identifier.
 * @property sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
 */
public data class WorkflowStepDeleteStepDetails(
    public val name: String? = null,
    public val sourceFileLocation: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.WorkflowStepDeleteStepDetails):
            WorkflowStepDeleteStepDetails = WorkflowStepDeleteStepDetails(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            sourceFileLocation = javaType.sourceFileLocation().map({ args0 -> args0 }).orElse(null),
        )
    }
}
