@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name The name of the step, used as an identifier.
 * @property sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
 * @property tags Array that contains from 1 to 10 key/value pairs. See S3 Tags below.
 */
public data class WorkflowStepTagStepDetails(
    public val name: String? = null,
    public val sourceFileLocation: String? = null,
    public val tags: List<WorkflowStepTagStepDetailsTag>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.transfer.outputs.WorkflowStepTagStepDetails):
            WorkflowStepTagStepDetails = WorkflowStepTagStepDetails(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            sourceFileLocation = javaType.sourceFileLocation().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.transfer.kotlin.outputs.WorkflowStepTagStepDetailsTag.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
