@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin

import com.pulumi.aws.verifiedaccess.GroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a Verified Access Group.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.Group;
 * import com.pulumi.aws.verifiedaccess.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Group("example", GroupArgs.builder()
 *             .verifiedaccessInstanceId(aws_verifiedaccess_instance.example().id())
 *             .build());
 *     }
 * }
 * ```
 * @property description Description of the verified access group.
 * @property policyDocument
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property verifiedaccessInstanceId The id of the verified access instance this group is associated with.
 * The following arguments are optional:
 */
public data class GroupArgs(
    public val description: Output<String>? = null,
    public val policyDocument: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val verifiedaccessInstanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedaccess.GroupArgs> {
    override fun toJava(): com.pulumi.aws.verifiedaccess.GroupArgs =
        com.pulumi.aws.verifiedaccess.GroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .verifiedaccessInstanceId(verifiedaccessInstanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var policyDocument: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var verifiedaccessInstanceId: Output<String>? = null

    /**
     * @param value Description of the verified access group.
     */
    @JvmName("vsxunnigajqllbrn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("fkragtjnptquxuts")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rdnwjfucivejmwdq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The id of the verified access instance this group is associated with.
     * The following arguments are optional:
     */
    @JvmName("igtgwnuerfseqksr")
    public suspend fun verifiedaccessInstanceId(`value`: Output<String>) {
        this.verifiedaccessInstanceId = value
    }

    /**
     * @param value Description of the verified access group.
     */
    @JvmName("juxjdbcnaofjcepl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("kqvbsllpinnuepdj")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gbddwelkkswbbulj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kxrgpryjjeopcuhq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The id of the verified access instance this group is associated with.
     * The following arguments are optional:
     */
    @JvmName("xnhwcyjwrajpxhan")
    public suspend fun verifiedaccessInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifiedaccessInstanceId = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        description = description,
        policyDocument = policyDocument,
        tags = tags,
        verifiedaccessInstanceId = verifiedaccessInstanceId,
    )
}
