@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin

import com.pulumi.aws.verifiedaccess.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a Verified Access Instance.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.Instance;
 * import com.pulumi.aws.verifiedaccess.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .description("example")
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ### With `fips_enabled`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.Instance;
 * import com.pulumi.aws.verifiedaccess.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .fipsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Verified Access Instances using the
 * `id`. For example:
 * ```sh
 *  $ pulumi import aws:verifiedaccess/instance:Instance example vai-1234567890abcdef0
 * ```
 * @property description A description for the AWS Verified Access Instance.
 * @property fipsEnabled Enable or disable support for Federal Information Processing Standards (FIPS) on the AWS Verified Access Instance.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class InstanceArgs(
    public val description: Output<String>? = null,
    public val fipsEnabled: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedaccess.InstanceArgs> {
    override fun toJava(): com.pulumi.aws.verifiedaccess.InstanceArgs =
        com.pulumi.aws.verifiedaccess.InstanceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .fipsEnabled(fipsEnabled?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var fipsEnabled: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A description for the AWS Verified Access Instance.
     */
    @JvmName("uwbpocoagnojkmml")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Enable or disable support for Federal Information Processing Standards (FIPS) on the AWS Verified Access Instance.
     */
    @JvmName("ebnuuxqtdrrdnhbc")
    public suspend fun fipsEnabled(`value`: Output<Boolean>) {
        this.fipsEnabled = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("enxcpjpybfdaovnn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A description for the AWS Verified Access Instance.
     */
    @JvmName("uscokgbkajkskksc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Enable or disable support for Federal Information Processing Standards (FIPS) on the AWS Verified Access Instance.
     */
    @JvmName("idpebpndrmyqertq")
    public suspend fun fipsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fipsEnabled = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("erpvtsocergybpoh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("frnjfamoeutelrrm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        description = description,
        fipsEnabled = fipsEnabled,
        tags = tags,
    )
}
