@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin

import com.pulumi.aws.verifiedaccess.kotlin.outputs.InstanceLoggingConfigurationAccessLogs
import com.pulumi.aws.verifiedaccess.kotlin.outputs.InstanceLoggingConfigurationAccessLogs.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InstanceLoggingConfiguration].
 */
@PulumiTagMarker
public class InstanceLoggingConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceLoggingConfigurationArgs = InstanceLoggingConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceLoggingConfigurationArgsBuilder.() -> Unit) {
        val builder = InstanceLoggingConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InstanceLoggingConfiguration {
        val builtJavaResource =
            com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InstanceLoggingConfiguration(builtJavaResource)
    }
}

/**
 * Resource for managing a Verified Access Logging Configuration.
 * ## Example Usage
 * ### With CloudWatch Logging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceLoggingConfiguration("example", InstanceLoggingConfigurationArgs.builder()
 *             .accessLogs(InstanceLoggingConfigurationAccessLogsArgs.builder()
 *                 .cloudwatchLogs(InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs.builder()
 *                     .enabled(true)
 *                     .logGroup(aws_cloudwatch_log_group.example().id())
 *                     .build())
 *                 .build())
 *             .verifiedaccessInstanceId(aws_verifiedaccess_instance.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### With Kinesis Data Firehose Logging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceLoggingConfiguration("example", InstanceLoggingConfigurationArgs.builder()
 *             .accessLogs(InstanceLoggingConfigurationAccessLogsArgs.builder()
 *                 .kinesisDataFirehose(InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs.builder()
 *                     .deliveryStream(aws_kinesis_firehose_delivery_stream.example().name())
 *                     .enabled(true)
 *                     .build())
 *                 .build())
 *             .verifiedaccessInstanceId(aws_verifiedaccess_instance.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### With S3 logging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsS3Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceLoggingConfiguration("example", InstanceLoggingConfigurationArgs.builder()
 *             .accessLogs(InstanceLoggingConfigurationAccessLogsArgs.builder()
 *                 .s3(InstanceLoggingConfigurationAccessLogsS3Args.builder()
 *                     .bucketName(aws_s3_bucket.example().id())
 *                     .enabled(true)
 *                     .prefix("example")
 *                     .build())
 *                 .build())
 *             .verifiedaccessInstanceId(aws_verifiedaccess_instance.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### With all three logging options
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsS3Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceLoggingConfiguration("example", InstanceLoggingConfigurationArgs.builder()
 *             .accessLogs(InstanceLoggingConfigurationAccessLogsArgs.builder()
 *                 .cloudwatchLogs(InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs.builder()
 *                     .enabled(true)
 *                     .logGroup(aws_cloudwatch_log_group.example().id())
 *                     .build())
 *                 .kinesisDataFirehose(InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs.builder()
 *                     .deliveryStream(aws_kinesis_firehose_delivery_stream.example().name())
 *                     .enabled(true)
 *                     .build())
 *                 .s3(InstanceLoggingConfigurationAccessLogsS3Args.builder()
 *                     .bucketName(aws_s3_bucket.example().id())
 *                     .enabled(true)
 *                     .build())
 *                 .build())
 *             .verifiedaccessInstanceId(aws_verifiedaccess_instance.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### With `include_trust_context`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceLoggingConfiguration("example", InstanceLoggingConfigurationArgs.builder()
 *             .accessLogs(InstanceLoggingConfigurationAccessLogsArgs.builder()
 *                 .includeTrustContext(true)
 *                 .build())
 *             .verifiedaccessInstanceId(aws_verifiedaccess_instance.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### With `log_version`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceLoggingConfiguration("example", InstanceLoggingConfigurationArgs.builder()
 *             .accessLogs(InstanceLoggingConfigurationAccessLogsArgs.builder()
 *                 .logVersion("ocsf-1.0.0-rc.2")
 *                 .build())
 *             .verifiedaccessInstanceId(aws_verifiedaccess_instance.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Verified Access Logging Configuration using the Verified Access Instance `id`. For example:
 * ```sh
 *  $ pulumi import aws:verifiedaccess/instanceLoggingConfiguration:InstanceLoggingConfiguration example vai-1234567890abcdef0
 * ```
 *
 */
public class InstanceLoggingConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration,
) : KotlinCustomResource(javaResource, InstanceLoggingConfigurationMapper) {
    /**
     * A block that specifies the configuration options for Verified Access instances. Detailed below.
     */
    public val accessLogs: Output<InstanceLoggingConfigurationAccessLogs>
        get() = javaResource.accessLogs().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The ID of the Verified Access instance.
     */
    public val verifiedaccessInstanceId: Output<String>
        get() = javaResource.verifiedaccessInstanceId().applyValue({ args0 -> args0 })
}

public object InstanceLoggingConfigurationMapper : ResourceMapper<InstanceLoggingConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): InstanceLoggingConfiguration =
        InstanceLoggingConfiguration(
            javaResource as
                com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration,
        )
}

/**
 * @see [InstanceLoggingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceLoggingConfiguration].
 */
public suspend fun instanceLoggingConfiguration(
    name: String,
    block: suspend InstanceLoggingConfigurationResourceBuilder.() -> Unit,
):
    InstanceLoggingConfiguration {
    val builder = InstanceLoggingConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceLoggingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceLoggingConfiguration(name: String): InstanceLoggingConfiguration {
    val builder = InstanceLoggingConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
