@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin

import com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs.builder
import com.pulumi.aws.verifiedaccess.kotlin.inputs.InstanceLoggingConfigurationAccessLogsArgs
import com.pulumi.aws.verifiedaccess.kotlin.inputs.InstanceLoggingConfigurationAccessLogsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing a Verified Access Logging Configuration.
 * ## Example Usage
 * ### With CloudWatch Logging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceLoggingConfiguration("example", InstanceLoggingConfigurationArgs.builder()
 *             .accessLogs(InstanceLoggingConfigurationAccessLogsArgs.builder()
 *                 .cloudwatchLogs(InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs.builder()
 *                     .enabled(true)
 *                     .logGroup(aws_cloudwatch_log_group.example().id())
 *                     .build())
 *                 .build())
 *             .verifiedaccessInstanceId(aws_verifiedaccess_instance.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### With Kinesis Data Firehose Logging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceLoggingConfiguration("example", InstanceLoggingConfigurationArgs.builder()
 *             .accessLogs(InstanceLoggingConfigurationAccessLogsArgs.builder()
 *                 .kinesisDataFirehose(InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs.builder()
 *                     .deliveryStream(aws_kinesis_firehose_delivery_stream.example().name())
 *                     .enabled(true)
 *                     .build())
 *                 .build())
 *             .verifiedaccessInstanceId(aws_verifiedaccess_instance.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### With S3 logging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsS3Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceLoggingConfiguration("example", InstanceLoggingConfigurationArgs.builder()
 *             .accessLogs(InstanceLoggingConfigurationAccessLogsArgs.builder()
 *                 .s3(InstanceLoggingConfigurationAccessLogsS3Args.builder()
 *                     .bucketName(aws_s3_bucket.example().id())
 *                     .enabled(true)
 *                     .prefix("example")
 *                     .build())
 *                 .build())
 *             .verifiedaccessInstanceId(aws_verifiedaccess_instance.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### With all three logging options
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsS3Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceLoggingConfiguration("example", InstanceLoggingConfigurationArgs.builder()
 *             .accessLogs(InstanceLoggingConfigurationAccessLogsArgs.builder()
 *                 .cloudwatchLogs(InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs.builder()
 *                     .enabled(true)
 *                     .logGroup(aws_cloudwatch_log_group.example().id())
 *                     .build())
 *                 .kinesisDataFirehose(InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs.builder()
 *                     .deliveryStream(aws_kinesis_firehose_delivery_stream.example().name())
 *                     .enabled(true)
 *                     .build())
 *                 .s3(InstanceLoggingConfigurationAccessLogsS3Args.builder()
 *                     .bucketName(aws_s3_bucket.example().id())
 *                     .enabled(true)
 *                     .build())
 *                 .build())
 *             .verifiedaccessInstanceId(aws_verifiedaccess_instance.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### With `include_trust_context`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceLoggingConfiguration("example", InstanceLoggingConfigurationArgs.builder()
 *             .accessLogs(InstanceLoggingConfigurationAccessLogsArgs.builder()
 *                 .includeTrustContext(true)
 *                 .build())
 *             .verifiedaccessInstanceId(aws_verifiedaccess_instance.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### With `log_version`
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfiguration;
 * import com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceLoggingConfiguration("example", InstanceLoggingConfigurationArgs.builder()
 *             .accessLogs(InstanceLoggingConfigurationAccessLogsArgs.builder()
 *                 .logVersion("ocsf-1.0.0-rc.2")
 *                 .build())
 *             .verifiedaccessInstanceId(aws_verifiedaccess_instance.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Verified Access Logging Configuration using the Verified Access Instance `id`. For example:
 * ```sh
 *  $ pulumi import aws:verifiedaccess/instanceLoggingConfiguration:InstanceLoggingConfiguration example vai-1234567890abcdef0
 * ```
 * @property accessLogs A block that specifies the configuration options for Verified Access instances. Detailed below.
 * @property verifiedaccessInstanceId The ID of the Verified Access instance.
 */
public data class InstanceLoggingConfigurationArgs(
    public val accessLogs: Output<InstanceLoggingConfigurationAccessLogsArgs>? = null,
    public val verifiedaccessInstanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs =
        com.pulumi.aws.verifiedaccess.InstanceLoggingConfigurationArgs.builder()
            .accessLogs(accessLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .verifiedaccessInstanceId(verifiedaccessInstanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceLoggingConfigurationArgs].
 */
@PulumiTagMarker
public class InstanceLoggingConfigurationArgsBuilder internal constructor() {
    private var accessLogs: Output<InstanceLoggingConfigurationAccessLogsArgs>? = null

    private var verifiedaccessInstanceId: Output<String>? = null

    /**
     * @param value A block that specifies the configuration options for Verified Access instances. Detailed below.
     */
    @JvmName("jtwsrxrnviecdqxt")
    public suspend fun accessLogs(`value`: Output<InstanceLoggingConfigurationAccessLogsArgs>) {
        this.accessLogs = value
    }

    /**
     * @param value The ID of the Verified Access instance.
     */
    @JvmName("pjektcttifkoqfdy")
    public suspend fun verifiedaccessInstanceId(`value`: Output<String>) {
        this.verifiedaccessInstanceId = value
    }

    /**
     * @param value A block that specifies the configuration options for Verified Access instances. Detailed below.
     */
    @JvmName("ndguwhecsfamgwwr")
    public suspend fun accessLogs(`value`: InstanceLoggingConfigurationAccessLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLogs = mapped
    }

    /**
     * @param argument A block that specifies the configuration options for Verified Access instances. Detailed below.
     */
    @JvmName("ficpndcvtspkoure")
    public suspend
    fun accessLogs(argument: suspend InstanceLoggingConfigurationAccessLogsArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceLoggingConfigurationAccessLogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.accessLogs = mapped
    }

    /**
     * @param value The ID of the Verified Access instance.
     */
    @JvmName("vihfiynkfpauhjlg")
    public suspend fun verifiedaccessInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifiedaccessInstanceId = mapped
    }

    internal fun build(): InstanceLoggingConfigurationArgs = InstanceLoggingConfigurationArgs(
        accessLogs = accessLogs,
        verifiedaccessInstanceId = verifiedaccessInstanceId,
    )
}
