@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InstanceTrustProviderAttachment].
 */
@PulumiTagMarker
public class InstanceTrustProviderAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceTrustProviderAttachmentArgs = InstanceTrustProviderAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceTrustProviderAttachmentArgsBuilder.() -> Unit) {
        val builder = InstanceTrustProviderAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InstanceTrustProviderAttachment {
        val builtJavaResource =
            com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InstanceTrustProviderAttachment(builtJavaResource)
    }
}

/**
 * Resource for managing a Verified Access Instance Trust Provider Attachment.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.Instance;
 * import com.pulumi.aws.verifiedaccess.TrustProvider;
 * import com.pulumi.aws.verifiedaccess.TrustProviderArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.TrustProviderDeviceOptionsArgs;
 * import com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachment;
 * import com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleInstance = new Instance("exampleInstance");
 *         var exampleTrustProvider = new TrustProvider("exampleTrustProvider", TrustProviderArgs.builder()
 *             .deviceTrustProviderType("jamf")
 *             .policyReferenceName("example")
 *             .trustProviderType("device")
 *             .deviceOptions(TrustProviderDeviceOptionsArgs.builder()
 *                 .tenantId("example")
 *                 .build())
 *             .build());
 *         var exampleInstanceTrustProviderAttachment = new InstanceTrustProviderAttachment("exampleInstanceTrustProviderAttachment", InstanceTrustProviderAttachmentArgs.builder()
 *             .verifiedaccessInstanceId(exampleInstance.id())
 *             .verifiedaccessTrustProviderId(exampleTrustProvider.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Verified Access Instance Trust Provider Attachments using the `verifiedaccess_instance_id` and `verifiedaccess_trust_provider_id` separated by a forward slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:verifiedaccess/instanceTrustProviderAttachment:InstanceTrustProviderAttachment example vai-1234567890abcdef0/vatp-8012925589
 * ```
 *
 */
public class InstanceTrustProviderAttachment internal constructor(
    override val javaResource: com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachment,
) : KotlinCustomResource(javaResource, InstanceTrustProviderAttachmentMapper) {
    /**
     * The ID of the Verified Access instance to attach the Trust Provider to.
     */
    public val verifiedaccessInstanceId: Output<String>
        get() = javaResource.verifiedaccessInstanceId().applyValue({ args0 -> args0 })

    /**
     * The ID of the Verified Access trust provider.
     */
    public val verifiedaccessTrustProviderId: Output<String>
        get() = javaResource.verifiedaccessTrustProviderId().applyValue({ args0 -> args0 })
}

public object InstanceTrustProviderAttachmentMapper :
    ResourceMapper<InstanceTrustProviderAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachment::class == javaResource::class

    override fun map(javaResource: Resource): InstanceTrustProviderAttachment =
        InstanceTrustProviderAttachment(
            javaResource as
                com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachment,
        )
}

/**
 * @see [InstanceTrustProviderAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceTrustProviderAttachment].
 */
public suspend fun instanceTrustProviderAttachment(
    name: String,
    block: suspend InstanceTrustProviderAttachmentResourceBuilder.() -> Unit,
):
    InstanceTrustProviderAttachment {
    val builder = InstanceTrustProviderAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceTrustProviderAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceTrustProviderAttachment(name: String): InstanceTrustProviderAttachment {
    val builder = InstanceTrustProviderAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
