@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin

import com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing a Verified Access Instance Trust Provider Attachment.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.Instance;
 * import com.pulumi.aws.verifiedaccess.TrustProvider;
 * import com.pulumi.aws.verifiedaccess.TrustProviderArgs;
 * import com.pulumi.aws.verifiedaccess.inputs.TrustProviderDeviceOptionsArgs;
 * import com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachment;
 * import com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleInstance = new Instance("exampleInstance");
 *         var exampleTrustProvider = new TrustProvider("exampleTrustProvider", TrustProviderArgs.builder()
 *             .deviceTrustProviderType("jamf")
 *             .policyReferenceName("example")
 *             .trustProviderType("device")
 *             .deviceOptions(TrustProviderDeviceOptionsArgs.builder()
 *                 .tenantId("example")
 *                 .build())
 *             .build());
 *         var exampleInstanceTrustProviderAttachment = new InstanceTrustProviderAttachment("exampleInstanceTrustProviderAttachment", InstanceTrustProviderAttachmentArgs.builder()
 *             .verifiedaccessInstanceId(exampleInstance.id())
 *             .verifiedaccessTrustProviderId(exampleTrustProvider.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Verified Access Instance Trust Provider Attachments using the `verifiedaccess_instance_id` and `verifiedaccess_trust_provider_id` separated by a forward slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:verifiedaccess/instanceTrustProviderAttachment:InstanceTrustProviderAttachment example vai-1234567890abcdef0/vatp-8012925589
 * ```
 * @property verifiedaccessInstanceId The ID of the Verified Access instance to attach the Trust Provider to.
 * @property verifiedaccessTrustProviderId The ID of the Verified Access trust provider.
 */
public data class InstanceTrustProviderAttachmentArgs(
    public val verifiedaccessInstanceId: Output<String>? = null,
    public val verifiedaccessTrustProviderId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachmentArgs =
        com.pulumi.aws.verifiedaccess.InstanceTrustProviderAttachmentArgs.builder()
            .verifiedaccessInstanceId(verifiedaccessInstanceId?.applyValue({ args0 -> args0 }))
            .verifiedaccessTrustProviderId(
                verifiedaccessTrustProviderId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [InstanceTrustProviderAttachmentArgs].
 */
@PulumiTagMarker
public class InstanceTrustProviderAttachmentArgsBuilder internal constructor() {
    private var verifiedaccessInstanceId: Output<String>? = null

    private var verifiedaccessTrustProviderId: Output<String>? = null

    /**
     * @param value The ID of the Verified Access instance to attach the Trust Provider to.
     */
    @JvmName("sorqviaxqodtsjne")
    public suspend fun verifiedaccessInstanceId(`value`: Output<String>) {
        this.verifiedaccessInstanceId = value
    }

    /**
     * @param value The ID of the Verified Access trust provider.
     */
    @JvmName("mrkfijwxhbfkqvwv")
    public suspend fun verifiedaccessTrustProviderId(`value`: Output<String>) {
        this.verifiedaccessTrustProviderId = value
    }

    /**
     * @param value The ID of the Verified Access instance to attach the Trust Provider to.
     */
    @JvmName("btnjqilvirsrlcps")
    public suspend fun verifiedaccessInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifiedaccessInstanceId = mapped
    }

    /**
     * @param value The ID of the Verified Access trust provider.
     */
    @JvmName("jfclcqbpacrynkxu")
    public suspend fun verifiedaccessTrustProviderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifiedaccessTrustProviderId = mapped
    }

    internal fun build(): InstanceTrustProviderAttachmentArgs = InstanceTrustProviderAttachmentArgs(
        verifiedaccessInstanceId = verifiedaccessInstanceId,
        verifiedaccessTrustProviderId = verifiedaccessTrustProviderId,
    )
}
