@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin

import com.pulumi.aws.verifiedaccess.kotlin.outputs.TrustProviderDeviceOptions
import com.pulumi.aws.verifiedaccess.kotlin.outputs.TrustProviderOidcOptions
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.verifiedaccess.kotlin.outputs.TrustProviderDeviceOptions.Companion.toKotlin as trustProviderDeviceOptionsToKotlin
import com.pulumi.aws.verifiedaccess.kotlin.outputs.TrustProviderOidcOptions.Companion.toKotlin as trustProviderOidcOptionsToKotlin

/**
 * Builder for [TrustProvider].
 */
@PulumiTagMarker
public class TrustProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrustProviderArgs = TrustProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrustProviderArgsBuilder.() -> Unit) {
        val builder = TrustProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TrustProvider {
        val builtJavaResource = com.pulumi.aws.verifiedaccess.TrustProvider(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrustProvider(builtJavaResource)
    }
}

/**
 * Resource for managing a Verified Access Trust Provider.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.TrustProvider;
 * import com.pulumi.aws.verifiedaccess.TrustProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TrustProvider("example", TrustProviderArgs.builder()
 *             .policyReferenceName("example")
 *             .trustProviderType("user")
 *             .userTrustProviderType("iam-identity-center")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transfer Workflows using the
 * `id`. For example:
 * ```sh
 *  $ pulumi import aws:verifiedaccess/trustProvider:TrustProvider example vatp-8012925589
 * ```
 *
 */
public class TrustProvider internal constructor(
    override val javaResource: com.pulumi.aws.verifiedaccess.TrustProvider,
) : KotlinCustomResource(javaResource, TrustProviderMapper) {
    /**
     * A description for the AWS Verified Access trust provider.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A block of options for device identity based trust providers.
     */
    public val deviceOptions: Output<TrustProviderDeviceOptions>?
        get() = javaResource.deviceOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> trustProviderDeviceOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The type of device-based trust provider.
     */
    public val deviceTrustProviderType: Output<String>?
        get() = javaResource.deviceTrustProviderType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The OpenID Connect details for an oidc-type, user-identity based trust provider.
     */
    public val oidcOptions: Output<TrustProviderOidcOptions>?
        get() = javaResource.oidcOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    trustProviderOidcOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The identifier to be used when working with policy rules.
     */
    public val policyReferenceName: Output<String>
        get() = javaResource.policyReferenceName().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of trust provider can be either user or device-based.
     * The following arguments are optional:
     */
    public val trustProviderType: Output<String>
        get() = javaResource.trustProviderType().applyValue({ args0 -> args0 })

    /**
     * The type of user-based trust provider.
     */
    public val userTrustProviderType: Output<String>?
        get() = javaResource.userTrustProviderType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object TrustProviderMapper : ResourceMapper<TrustProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.verifiedaccess.TrustProvider::class == javaResource::class

    override fun map(javaResource: Resource): TrustProvider = TrustProvider(
        javaResource as
            com.pulumi.aws.verifiedaccess.TrustProvider,
    )
}

/**
 * @see [TrustProvider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrustProvider].
 */
public suspend fun trustProvider(
    name: String,
    block: suspend TrustProviderResourceBuilder.() -> Unit,
): TrustProvider {
    val builder = TrustProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrustProvider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trustProvider(name: String): TrustProvider {
    val builder = TrustProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
