@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin

import com.pulumi.aws.verifiedaccess.TrustProviderArgs.builder
import com.pulumi.aws.verifiedaccess.kotlin.inputs.TrustProviderDeviceOptionsArgs
import com.pulumi.aws.verifiedaccess.kotlin.inputs.TrustProviderDeviceOptionsArgsBuilder
import com.pulumi.aws.verifiedaccess.kotlin.inputs.TrustProviderOidcOptionsArgs
import com.pulumi.aws.verifiedaccess.kotlin.inputs.TrustProviderOidcOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a Verified Access Trust Provider.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.verifiedaccess.TrustProvider;
 * import com.pulumi.aws.verifiedaccess.TrustProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TrustProvider("example", TrustProviderArgs.builder()
 *             .policyReferenceName("example")
 *             .trustProviderType("user")
 *             .userTrustProviderType("iam-identity-center")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Transfer Workflows using the
 * `id`. For example:
 * ```sh
 *  $ pulumi import aws:verifiedaccess/trustProvider:TrustProvider example vatp-8012925589
 * ```
 * @property description A description for the AWS Verified Access trust provider.
 * @property deviceOptions A block of options for device identity based trust providers.
 * @property deviceTrustProviderType The type of device-based trust provider.
 * @property oidcOptions The OpenID Connect details for an oidc-type, user-identity based trust provider.
 * @property policyReferenceName The identifier to be used when working with policy rules.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property trustProviderType The type of trust provider can be either user or device-based.
 * The following arguments are optional:
 * @property userTrustProviderType The type of user-based trust provider.
 */
public data class TrustProviderArgs(
    public val description: Output<String>? = null,
    public val deviceOptions: Output<TrustProviderDeviceOptionsArgs>? = null,
    public val deviceTrustProviderType: Output<String>? = null,
    public val oidcOptions: Output<TrustProviderOidcOptionsArgs>? = null,
    public val policyReferenceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trustProviderType: Output<String>? = null,
    public val userTrustProviderType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedaccess.TrustProviderArgs> {
    override fun toJava(): com.pulumi.aws.verifiedaccess.TrustProviderArgs =
        com.pulumi.aws.verifiedaccess.TrustProviderArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .deviceOptions(deviceOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deviceTrustProviderType(deviceTrustProviderType?.applyValue({ args0 -> args0 }))
            .oidcOptions(oidcOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .policyReferenceName(policyReferenceName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trustProviderType(trustProviderType?.applyValue({ args0 -> args0 }))
            .userTrustProviderType(userTrustProviderType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrustProviderArgs].
 */
@PulumiTagMarker
public class TrustProviderArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var deviceOptions: Output<TrustProviderDeviceOptionsArgs>? = null

    private var deviceTrustProviderType: Output<String>? = null

    private var oidcOptions: Output<TrustProviderOidcOptionsArgs>? = null

    private var policyReferenceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trustProviderType: Output<String>? = null

    private var userTrustProviderType: Output<String>? = null

    /**
     * @param value A description for the AWS Verified Access trust provider.
     */
    @JvmName("vkmrjraehlfbxrvt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A block of options for device identity based trust providers.
     */
    @JvmName("inpiohrgsjmrocwy")
    public suspend fun deviceOptions(`value`: Output<TrustProviderDeviceOptionsArgs>) {
        this.deviceOptions = value
    }

    /**
     * @param value The type of device-based trust provider.
     */
    @JvmName("pirmprkmacijixmn")
    public suspend fun deviceTrustProviderType(`value`: Output<String>) {
        this.deviceTrustProviderType = value
    }

    /**
     * @param value The OpenID Connect details for an oidc-type, user-identity based trust provider.
     */
    @JvmName("biwdgmtjhxogfmou")
    public suspend fun oidcOptions(`value`: Output<TrustProviderOidcOptionsArgs>) {
        this.oidcOptions = value
    }

    /**
     * @param value The identifier to be used when working with policy rules.
     */
    @JvmName("opkphbnxmgdceetj")
    public suspend fun policyReferenceName(`value`: Output<String>) {
        this.policyReferenceName = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hjcnvrkvevikvrov")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of trust provider can be either user or device-based.
     * The following arguments are optional:
     */
    @JvmName("yeyanaaswuvwvdtf")
    public suspend fun trustProviderType(`value`: Output<String>) {
        this.trustProviderType = value
    }

    /**
     * @param value The type of user-based trust provider.
     */
    @JvmName("lfxadvfhyifeoqqs")
    public suspend fun userTrustProviderType(`value`: Output<String>) {
        this.userTrustProviderType = value
    }

    /**
     * @param value A description for the AWS Verified Access trust provider.
     */
    @JvmName("ivcvxsnkxtppdgph")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A block of options for device identity based trust providers.
     */
    @JvmName("skksrseetcvbiljm")
    public suspend fun deviceOptions(`value`: TrustProviderDeviceOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceOptions = mapped
    }

    /**
     * @param argument A block of options for device identity based trust providers.
     */
    @JvmName("mkefmbmsxfqwjwps")
    public suspend
    fun deviceOptions(argument: suspend TrustProviderDeviceOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = TrustProviderDeviceOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deviceOptions = mapped
    }

    /**
     * @param value The type of device-based trust provider.
     */
    @JvmName("qgnbrtgvliefitms")
    public suspend fun deviceTrustProviderType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceTrustProviderType = mapped
    }

    /**
     * @param value The OpenID Connect details for an oidc-type, user-identity based trust provider.
     */
    @JvmName("ncbeeeuncmncbgqp")
    public suspend fun oidcOptions(`value`: TrustProviderOidcOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidcOptions = mapped
    }

    /**
     * @param argument The OpenID Connect details for an oidc-type, user-identity based trust provider.
     */
    @JvmName("abogxjdtascjlkau")
    public suspend fun oidcOptions(argument: suspend TrustProviderOidcOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = TrustProviderOidcOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.oidcOptions = mapped
    }

    /**
     * @param value The identifier to be used when working with policy rules.
     */
    @JvmName("twmwhcgillgedmxe")
    public suspend fun policyReferenceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyReferenceName = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ntykmdijailwncfk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ifpfapfeesxfbdob")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of trust provider can be either user or device-based.
     * The following arguments are optional:
     */
    @JvmName("cdvtnqfemxkyvpnr")
    public suspend fun trustProviderType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustProviderType = mapped
    }

    /**
     * @param value The type of user-based trust provider.
     */
    @JvmName("lfbcvgvlwgrvwypm")
    public suspend fun userTrustProviderType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userTrustProviderType = mapped
    }

    internal fun build(): TrustProviderArgs = TrustProviderArgs(
        description = description,
        deviceOptions = deviceOptions,
        deviceTrustProviderType = deviceTrustProviderType,
        oidcOptions = oidcOptions,
        policyReferenceName = policyReferenceName,
        tags = tags,
        trustProviderType = trustProviderType,
        userTrustProviderType = userTrustProviderType,
    )
}
