@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.inputs

import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogs A block that specifies configures sending Verified Access logs to CloudWatch Logs. Detailed below.
 * @property includeTrustContext Include trust data sent by trust providers into the logs.
 * @property kinesisDataFirehose A block that specifies configures sending Verified Access logs to Kinesis. Detailed below.
 * @property logVersion The logging version to use. Refer to [VerifiedAccessLogOptions](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VerifiedAccessLogOptions.html) for the allowed values.
 * @property s3 A block that specifies configures sending Verified Access logs to S3. Detailed below.
 */
public data class InstanceLoggingConfigurationAccessLogsArgs(
    public val cloudwatchLogs: Output<InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs>? =
        null,
    public val includeTrustContext: Output<Boolean>? = null,
    public val kinesisDataFirehose:
    Output<InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs>? = null,
    public val logVersion: Output<String>? = null,
    public val s3: Output<InstanceLoggingConfigurationAccessLogsS3Args>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs> {
    override fun toJava():
        com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs =
        com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsArgs.builder()
            .cloudwatchLogs(cloudwatchLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .includeTrustContext(includeTrustContext?.applyValue({ args0 -> args0 }))
            .kinesisDataFirehose(
                kinesisDataFirehose?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .logVersion(logVersion?.applyValue({ args0 -> args0 }))
            .s3(s3?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InstanceLoggingConfigurationAccessLogsArgs].
 */
@PulumiTagMarker
public class InstanceLoggingConfigurationAccessLogsArgsBuilder internal constructor() {
    private var cloudwatchLogs: Output<InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs>? =
        null

    private var includeTrustContext: Output<Boolean>? = null

    private var kinesisDataFirehose:
        Output<InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs>? = null

    private var logVersion: Output<String>? = null

    private var s3: Output<InstanceLoggingConfigurationAccessLogsS3Args>? = null

    /**
     * @param value A block that specifies configures sending Verified Access logs to CloudWatch Logs. Detailed below.
     */
    @JvmName("btiehukqjxtyxmaw")
    public suspend
    fun cloudwatchLogs(`value`: Output<InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs>) {
        this.cloudwatchLogs = value
    }

    /**
     * @param value Include trust data sent by trust providers into the logs.
     */
    @JvmName("jxebcemibhlcnxtx")
    public suspend fun includeTrustContext(`value`: Output<Boolean>) {
        this.includeTrustContext = value
    }

    /**
     * @param value A block that specifies configures sending Verified Access logs to Kinesis. Detailed below.
     */
    @JvmName("ooqomuejhxuwmmuq")
    public suspend
    fun kinesisDataFirehose(`value`: Output<InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs>) {
        this.kinesisDataFirehose = value
    }

    /**
     * @param value The logging version to use. Refer to [VerifiedAccessLogOptions](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VerifiedAccessLogOptions.html) for the allowed values.
     */
    @JvmName("adeywacaxkcbphql")
    public suspend fun logVersion(`value`: Output<String>) {
        this.logVersion = value
    }

    /**
     * @param value A block that specifies configures sending Verified Access logs to S3. Detailed below.
     */
    @JvmName("renlaiqakclmiaok")
    public suspend fun s3(`value`: Output<InstanceLoggingConfigurationAccessLogsS3Args>) {
        this.s3 = value
    }

    /**
     * @param value A block that specifies configures sending Verified Access logs to CloudWatch Logs. Detailed below.
     */
    @JvmName("sofaricatwobtmhd")
    public suspend
    fun cloudwatchLogs(`value`: InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogs = mapped
    }

    /**
     * @param argument A block that specifies configures sending Verified Access logs to CloudWatch Logs. Detailed below.
     */
    @JvmName("buwpbntfdqukvixm")
    public suspend
    fun cloudwatchLogs(argument: suspend InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLogs = mapped
    }

    /**
     * @param value Include trust data sent by trust providers into the logs.
     */
    @JvmName("uohtaicuvqnexofi")
    public suspend fun includeTrustContext(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeTrustContext = mapped
    }

    /**
     * @param value A block that specifies configures sending Verified Access logs to Kinesis. Detailed below.
     */
    @JvmName("sktwqvolmuscxsjl")
    public suspend
    fun kinesisDataFirehose(`value`: InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisDataFirehose = mapped
    }

    /**
     * @param argument A block that specifies configures sending Verified Access logs to Kinesis. Detailed below.
     */
    @JvmName("kwdrwdpsncymtmbw")
    public suspend
    fun kinesisDataFirehose(argument: suspend InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgsBuilder.() -> Unit) {
        val toBeMapped =
            InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.kinesisDataFirehose = mapped
    }

    /**
     * @param value The logging version to use. Refer to [VerifiedAccessLogOptions](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VerifiedAccessLogOptions.html) for the allowed values.
     */
    @JvmName("ppcdaftvenvjlotb")
    public suspend fun logVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logVersion = mapped
    }

    /**
     * @param value A block that specifies configures sending Verified Access logs to S3. Detailed below.
     */
    @JvmName("xvsmaauycxkbdpbr")
    public suspend fun s3(`value`: InstanceLoggingConfigurationAccessLogsS3Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3 = mapped
    }

    /**
     * @param argument A block that specifies configures sending Verified Access logs to S3. Detailed below.
     */
    @JvmName("tygqrbnkwsjdbnln")
    public suspend
    fun s3(argument: suspend InstanceLoggingConfigurationAccessLogsS3ArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceLoggingConfigurationAccessLogsS3ArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3 = mapped
    }

    internal fun build(): InstanceLoggingConfigurationAccessLogsArgs =
        InstanceLoggingConfigurationAccessLogsArgs(
            cloudwatchLogs = cloudwatchLogs,
            includeTrustContext = includeTrustContext,
            kinesisDataFirehose = kinesisDataFirehose,
            logVersion = logVersion,
            s3 = s3,
        )
}
