@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.inputs

import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Indicates whether logging is enabled.
 * @property logGroup The name of the CloudWatch Logs Log Group.
 */
public data class InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs(
    public val enabled: Output<Boolean>,
    public val logGroup: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs> {
    override fun toJava():
        com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs =
        com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .logGroup(logGroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs].
 */
@PulumiTagMarker
public class InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var logGroup: Output<String>? = null

    /**
     * @param value Indicates whether logging is enabled.
     */
    @JvmName("gmibxxmcjexvljrb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The name of the CloudWatch Logs Log Group.
     */
    @JvmName("fsbaxrpvnfrpsllb")
    public suspend fun logGroup(`value`: Output<String>) {
        this.logGroup = value
    }

    /**
     * @param value Indicates whether logging is enabled.
     */
    @JvmName("yoiimknkfoxkhuwl")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The name of the CloudWatch Logs Log Group.
     */
    @JvmName("ypjwvrhgbuklragv")
    public suspend fun logGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroup = mapped
    }

    internal fun build(): InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs =
        InstanceLoggingConfigurationAccessLogsCloudwatchLogsArgs(
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            logGroup = logGroup,
        )
}
