@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.inputs

import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deliveryStream The name of the delivery stream.
 * @property enabled Indicates whether logging is enabled.
 */
public data class InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs(
    public val deliveryStream: Output<String>? = null,
    public val enabled: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs> {
    override fun toJava():
        com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs =
        com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs.builder()
            .deliveryStream(deliveryStream?.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs].
 */
@PulumiTagMarker
public class InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgsBuilder internal
constructor() {
    private var deliveryStream: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value The name of the delivery stream.
     */
    @JvmName("yyglakecqqsntpsw")
    public suspend fun deliveryStream(`value`: Output<String>) {
        this.deliveryStream = value
    }

    /**
     * @param value Indicates whether logging is enabled.
     */
    @JvmName("ojnqodcutsvetkqa")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The name of the delivery stream.
     */
    @JvmName("wosxoincyfhunhfa")
    public suspend fun deliveryStream(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryStream = mapped
    }

    /**
     * @param value Indicates whether logging is enabled.
     */
    @JvmName("qdqufitcllokfxub")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs =
        InstanceLoggingConfigurationAccessLogsKinesisDataFirehoseArgs(
            deliveryStream = deliveryStream,
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        )
}
