@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.inputs

import com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName The name of S3 bucket.
 * @property bucketOwner The ID of the AWS account that owns the Amazon S3 bucket.
 * @property enabled Indicates whether logging is enabled.
 * @property prefix The bucket prefix.
 */
public data class InstanceLoggingConfigurationAccessLogsS3Args(
    public val bucketName: Output<String>? = null,
    public val bucketOwner: Output<String>? = null,
    public val enabled: Output<Boolean>,
    public val prefix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsS3Args> {
    override fun toJava():
        com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsS3Args =
        com.pulumi.aws.verifiedaccess.inputs.InstanceLoggingConfigurationAccessLogsS3Args.builder()
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .bucketOwner(bucketOwner?.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceLoggingConfigurationAccessLogsS3Args].
 */
@PulumiTagMarker
public class InstanceLoggingConfigurationAccessLogsS3ArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var bucketOwner: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value The name of S3 bucket.
     */
    @JvmName("qjlmdhlksggamulw")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The ID of the AWS account that owns the Amazon S3 bucket.
     */
    @JvmName("motvncpynnhatbnx")
    public suspend fun bucketOwner(`value`: Output<String>) {
        this.bucketOwner = value
    }

    /**
     * @param value Indicates whether logging is enabled.
     */
    @JvmName("eawotsxptvwivlou")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The bucket prefix.
     */
    @JvmName("ulqbxlqsivyhxrgg")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value The name of S3 bucket.
     */
    @JvmName("ymqkdlkymgvcnjsc")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The ID of the AWS account that owns the Amazon S3 bucket.
     */
    @JvmName("hpouvsjssjbebelg")
    public suspend fun bucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketOwner = mapped
    }

    /**
     * @param value Indicates whether logging is enabled.
     */
    @JvmName("ljpwxrhukeespncr")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value The bucket prefix.
     */
    @JvmName("khlhvsrtnajfpvqt")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): InstanceLoggingConfigurationAccessLogsS3Args =
        InstanceLoggingConfigurationAccessLogsS3Args(
            bucketName = bucketName,
            bucketOwner = bucketOwner,
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            prefix = prefix,
        )
}
