@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.inputs

import com.pulumi.aws.verifiedaccess.inputs.TrustProviderOidcOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationEndpoint
 * @property clientId
 * @property clientSecret
 * @property issuer
 * @property scope
 * @property tokenEndpoint
 * @property userInfoEndpoint
 */
public data class TrustProviderOidcOptionsArgs(
    public val authorizationEndpoint: Output<String>? = null,
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>,
    public val issuer: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val tokenEndpoint: Output<String>? = null,
    public val userInfoEndpoint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.verifiedaccess.inputs.TrustProviderOidcOptionsArgs> {
    override fun toJava(): com.pulumi.aws.verifiedaccess.inputs.TrustProviderOidcOptionsArgs =
        com.pulumi.aws.verifiedaccess.inputs.TrustProviderOidcOptionsArgs.builder()
            .authorizationEndpoint(authorizationEndpoint?.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret.applyValue({ args0 -> args0 }))
            .issuer(issuer?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .tokenEndpoint(tokenEndpoint?.applyValue({ args0 -> args0 }))
            .userInfoEndpoint(userInfoEndpoint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrustProviderOidcOptionsArgs].
 */
@PulumiTagMarker
public class TrustProviderOidcOptionsArgsBuilder internal constructor() {
    private var authorizationEndpoint: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var issuer: Output<String>? = null

    private var scope: Output<String>? = null

    private var tokenEndpoint: Output<String>? = null

    private var userInfoEndpoint: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("dpwcqplixhrgpwxr")
    public suspend fun authorizationEndpoint(`value`: Output<String>) {
        this.authorizationEndpoint = value
    }

    /**
     * @param value
     */
    @JvmName("vqhixnostpeyktgt")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value
     */
    @JvmName("vtluetewwrtduavm")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value
     */
    @JvmName("ydqoxtwjtdxjvmax")
    public suspend fun issuer(`value`: Output<String>) {
        this.issuer = value
    }

    /**
     * @param value
     */
    @JvmName("osmfpywnlxydropr")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value
     */
    @JvmName("hmpjmbhfqqjibugf")
    public suspend fun tokenEndpoint(`value`: Output<String>) {
        this.tokenEndpoint = value
    }

    /**
     * @param value
     */
    @JvmName("hxbbwxhciinxswpi")
    public suspend fun userInfoEndpoint(`value`: Output<String>) {
        this.userInfoEndpoint = value
    }

    /**
     * @param value
     */
    @JvmName("pgqefdivjmxseadr")
    public suspend fun authorizationEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationEndpoint = mapped
    }

    /**
     * @param value
     */
    @JvmName("ndjcpkuoldkumowb")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value
     */
    @JvmName("donxuxqswxsdnuus")
    public suspend fun clientSecret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value
     */
    @JvmName("gfvnendvvkonlpmx")
    public suspend fun issuer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuer = mapped
    }

    /**
     * @param value
     */
    @JvmName("xaejdciistuiaiqm")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value
     */
    @JvmName("rhuptdjxgfsuwjbh")
    public suspend fun tokenEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenEndpoint = mapped
    }

    /**
     * @param value
     */
    @JvmName("hgiuppbvxdicrthw")
    public suspend fun userInfoEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userInfoEndpoint = mapped
    }

    internal fun build(): TrustProviderOidcOptionsArgs = TrustProviderOidcOptionsArgs(
        authorizationEndpoint = authorizationEndpoint,
        clientId = clientId,
        clientSecret = clientSecret ?: throw PulumiNullFieldException("clientSecret"),
        issuer = issuer,
        scope = scope,
        tokenEndpoint = tokenEndpoint,
        userInfoEndpoint = userInfoEndpoint,
    )
}
