@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property loadBalancerArn
 * @property port
 * @property protocol
 * @property subnetIds
 */
public data class EndpointLoadBalancerOptions(
    public val loadBalancerArn: String? = null,
    public val port: Int? = null,
    public val protocol: String? = null,
    public val subnetIds: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.verifiedaccess.outputs.EndpointLoadBalancerOptions):
            EndpointLoadBalancerOptions = EndpointLoadBalancerOptions(
            loadBalancerArn = javaType.loadBalancerArn().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
        )
    }
}
