@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property networkInterfaceId
 * @property port
 * @property protocol
 */
public data class EndpointNetworkInterfaceOptions(
    public val networkInterfaceId: String? = null,
    public val port: Int? = null,
    public val protocol: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.verifiedaccess.outputs.EndpointNetworkInterfaceOptions):
            EndpointNetworkInterfaceOptions = EndpointNetworkInterfaceOptions(
            networkInterfaceId = javaType.networkInterfaceId().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
        )
    }
}
