@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cloudwatchLogs A block that specifies configures sending Verified Access logs to CloudWatch Logs. Detailed below.
 * @property includeTrustContext Include trust data sent by trust providers into the logs.
 * @property kinesisDataFirehose A block that specifies configures sending Verified Access logs to Kinesis. Detailed below.
 * @property logVersion The logging version to use. Refer to [VerifiedAccessLogOptions](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VerifiedAccessLogOptions.html) for the allowed values.
 * @property s3 A block that specifies configures sending Verified Access logs to S3. Detailed below.
 */
public data class InstanceLoggingConfigurationAccessLogs(
    public val cloudwatchLogs: InstanceLoggingConfigurationAccessLogsCloudwatchLogs? = null,
    public val includeTrustContext: Boolean? = null,
    public val kinesisDataFirehose: InstanceLoggingConfigurationAccessLogsKinesisDataFirehose? = null,
    public val logVersion: String? = null,
    public val s3: InstanceLoggingConfigurationAccessLogsS3? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.verifiedaccess.outputs.InstanceLoggingConfigurationAccessLogs):
            InstanceLoggingConfigurationAccessLogs = InstanceLoggingConfigurationAccessLogs(
            cloudwatchLogs = javaType.cloudwatchLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.verifiedaccess.kotlin.outputs.InstanceLoggingConfigurationAccessLogsCloudwatchLogs.Companion.toKotlin(args0)
                })
            }).orElse(null),
            includeTrustContext = javaType.includeTrustContext().map({ args0 -> args0 }).orElse(null),
            kinesisDataFirehose = javaType.kinesisDataFirehose().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.verifiedaccess.kotlin.outputs.InstanceLoggingConfigurationAccessLogsKinesisDataFirehose.Companion.toKotlin(args0)
                })
            }).orElse(null),
            logVersion = javaType.logVersion().map({ args0 -> args0 }).orElse(null),
            s3 = javaType.s3().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.verifiedaccess.kotlin.outputs.InstanceLoggingConfigurationAccessLogsS3.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
