@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Indicates whether logging is enabled.
 * @property logGroup The name of the CloudWatch Logs Log Group.
 */
public data class InstanceLoggingConfigurationAccessLogsCloudwatchLogs(
    public val enabled: Boolean,
    public val logGroup: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.verifiedaccess.outputs.InstanceLoggingConfigurationAccessLogsCloudwatchLogs):
            InstanceLoggingConfigurationAccessLogsCloudwatchLogs =
            InstanceLoggingConfigurationAccessLogsCloudwatchLogs(
                enabled = javaType.enabled(),
                logGroup = javaType.logGroup().map({ args0 -> args0 }).orElse(null),
            )
    }
}
