@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName The name of S3 bucket.
 * @property bucketOwner The ID of the AWS account that owns the Amazon S3 bucket.
 * @property enabled Indicates whether logging is enabled.
 * @property prefix The bucket prefix.
 */
public data class InstanceLoggingConfigurationAccessLogsS3(
    public val bucketName: String? = null,
    public val bucketOwner: String? = null,
    public val enabled: Boolean,
    public val prefix: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.verifiedaccess.outputs.InstanceLoggingConfigurationAccessLogsS3):
            InstanceLoggingConfigurationAccessLogsS3 = InstanceLoggingConfigurationAccessLogsS3(
            bucketName = javaType.bucketName().map({ args0 -> args0 }).orElse(null),
            bucketOwner = javaType.bucketOwner().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
