@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.verifiedaccess.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authorizationEndpoint
 * @property clientId
 * @property clientSecret
 * @property issuer
 * @property scope
 * @property tokenEndpoint
 * @property userInfoEndpoint
 */
public data class TrustProviderOidcOptions(
    public val authorizationEndpoint: String? = null,
    public val clientId: String? = null,
    public val clientSecret: String,
    public val issuer: String? = null,
    public val scope: String? = null,
    public val tokenEndpoint: String? = null,
    public val userInfoEndpoint: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.verifiedaccess.outputs.TrustProviderOidcOptions):
            TrustProviderOidcOptions = TrustProviderOidcOptions(
            authorizationEndpoint = javaType.authorizationEndpoint().map({ args0 -> args0 }).orElse(null),
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clientSecret = javaType.clientSecret(),
            issuer = javaType.issuer().map({ args0 -> args0 }).orElse(null),
            scope = javaType.scope().map({ args0 -> args0 }).orElse(null),
            tokenEndpoint = javaType.tokenEndpoint().map({ args0 -> args0 }).orElse(null),
            userInfoEndpoint = javaType.userInfoEndpoint().map({ args0 -> args0 }).orElse(null),
        )
    }
}
