@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpc.kotlin

import com.pulumi.aws.vpc.SecurityGroupEgressRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an outbound (egress) rule for a security group.
 * When specifying an outbound rule for your security group in a VPC, the configuration must include a destination for the traffic.
 * > **NOTE on Security Groups and Security Group Rules:** this provider currently provides a Security Group resource with `ingress` and `egress` rules defined in-line and a Security Group Rule resource which manages one or more `ingress` or
 * `egress` rules. Both of these resource were added before AWS assigned a [security group rule unique ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules.html), and they do not work well in all scenarios using the`description` and `tags` attributes, which rely on the unique ID.
 * The `aws.vpc.SecurityGroupEgressRule` resource has been added to address these limitations and should be used for all new security group rules.
 * You should not use the `aws.vpc.SecurityGroupEgressRule` resource in conjunction with an `aws.ec2.SecurityGroup` resource with in-line rules or with `aws.ec2.SecurityGroupRule` resources defined for the same Security Group, as rule conflicts may occur and rules will be overwritten.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpc.SecurityGroupEgressRule;
 * import com.pulumi.aws.vpc.SecurityGroupEgressRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityGroupEgressRule("example", SecurityGroupEgressRuleArgs.builder()
 *             .securityGroupId(aws_security_group.example().id())
 *             .cidrIpv4("10.0.0.0/8")
 *             .fromPort(80)
 *             .ipProtocol("tcp")
 *             .toPort(80)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import security group egress rules using the `security_group_rule_id`. For example:
 * ```sh
 *  $ pulumi import aws:vpc/securityGroupEgressRule:SecurityGroupEgressRule example sgr-02108b27edd666983
 * ```
 * @property cidrIpv4 The destination IPv4 CIDR range.
 * @property cidrIpv6 The destination IPv6 CIDR range.
 * @property description The security group rule description.
 * @property fromPort The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
 * @property ipProtocol The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
 * @property prefixListId The ID of the destination prefix list.
 * @property referencedSecurityGroupId The destination security group that is referenced in the rule.
 * @property securityGroupId The ID of the security group.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property toPort The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
 */
public data class SecurityGroupEgressRuleArgs(
    public val cidrIpv4: Output<String>? = null,
    public val cidrIpv6: Output<String>? = null,
    public val description: Output<String>? = null,
    public val fromPort: Output<Int>? = null,
    public val ipProtocol: Output<String>? = null,
    public val prefixListId: Output<String>? = null,
    public val referencedSecurityGroupId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val toPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpc.SecurityGroupEgressRuleArgs> {
    override fun toJava(): com.pulumi.aws.vpc.SecurityGroupEgressRuleArgs =
        com.pulumi.aws.vpc.SecurityGroupEgressRuleArgs.builder()
            .cidrIpv4(cidrIpv4?.applyValue({ args0 -> args0 }))
            .cidrIpv6(cidrIpv6?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fromPort(fromPort?.applyValue({ args0 -> args0 }))
            .ipProtocol(ipProtocol?.applyValue({ args0 -> args0 }))
            .prefixListId(prefixListId?.applyValue({ args0 -> args0 }))
            .referencedSecurityGroupId(referencedSecurityGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .toPort(toPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityGroupEgressRuleArgs].
 */
@PulumiTagMarker
public class SecurityGroupEgressRuleArgsBuilder internal constructor() {
    private var cidrIpv4: Output<String>? = null

    private var cidrIpv6: Output<String>? = null

    private var description: Output<String>? = null

    private var fromPort: Output<Int>? = null

    private var ipProtocol: Output<String>? = null

    private var prefixListId: Output<String>? = null

    private var referencedSecurityGroupId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value The destination IPv4 CIDR range.
     */
    @JvmName("jttbxacwkgidhxkv")
    public suspend fun cidrIpv4(`value`: Output<String>) {
        this.cidrIpv4 = value
    }

    /**
     * @param value The destination IPv6 CIDR range.
     */
    @JvmName("lutopfvksbonjdji")
    public suspend fun cidrIpv6(`value`: Output<String>) {
        this.cidrIpv6 = value
    }

    /**
     * @param value The security group rule description.
     */
    @JvmName("hbeftebwvswsckjv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
     */
    @JvmName("rpqqsfitehrxlacq")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
     */
    @JvmName("jyiymdqahaldtcpm")
    public suspend fun ipProtocol(`value`: Output<String>) {
        this.ipProtocol = value
    }

    /**
     * @param value The ID of the destination prefix list.
     */
    @JvmName("rikewddeajqnotvi")
    public suspend fun prefixListId(`value`: Output<String>) {
        this.prefixListId = value
    }

    /**
     * @param value The destination security group that is referenced in the rule.
     */
    @JvmName("kbwoqqqfahiumfoh")
    public suspend fun referencedSecurityGroupId(`value`: Output<String>) {
        this.referencedSecurityGroupId = value
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("exgrcdsjwcbvnrdy")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qywhawwprdcpccnd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     */
    @JvmName("kuldabojkktntkkd")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value The destination IPv4 CIDR range.
     */
    @JvmName("vbijrduubfacftrd")
    public suspend fun cidrIpv4(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrIpv4 = mapped
    }

    /**
     * @param value The destination IPv6 CIDR range.
     */
    @JvmName("ocuitajxokaxrygr")
    public suspend fun cidrIpv6(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrIpv6 = mapped
    }

    /**
     * @param value The security group rule description.
     */
    @JvmName("kcisjxpnpumnovyh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
     */
    @JvmName("htabuvfoehriomdh")
    public suspend fun fromPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
     */
    @JvmName("mrkqsmyrgqjsnsnx")
    public suspend fun ipProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipProtocol = mapped
    }

    /**
     * @param value The ID of the destination prefix list.
     */
    @JvmName("mxebfsflggdyplur")
    public suspend fun prefixListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixListId = mapped
    }

    /**
     * @param value The destination security group that is referenced in the rule.
     */
    @JvmName("uomjhoqqhjjtyoid")
    public suspend fun referencedSecurityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referencedSecurityGroupId = mapped
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("fmmyceddodhldnyi")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ifjetbsrijncslfi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pagoerkaanvcteli")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     */
    @JvmName("oedwhjbyhkwbyono")
    public suspend fun toPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): SecurityGroupEgressRuleArgs = SecurityGroupEgressRuleArgs(
        cidrIpv4 = cidrIpv4,
        cidrIpv6 = cidrIpv6,
        description = description,
        fromPort = fromPort,
        ipProtocol = ipProtocol,
        prefixListId = prefixListId,
        referencedSecurityGroupId = referencedSecurityGroupId,
        securityGroupId = securityGroupId,
        tags = tags,
        toPort = toPort,
    )
}
