@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpc.kotlin

import com.pulumi.aws.vpc.SecurityGroupIngressRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an inbound (ingress) rule for a security group.
 * When specifying an inbound rule for your security group in a VPC, the configuration must include a source for the traffic.
 * > **NOTE on Security Groups and Security Group Rules:** this provider currently provides a Security Group resource with `ingress` and `egress` rules defined in-line and a Security Group Rule resource which manages one or more `ingress` or
 * `egress` rules. Both of these resource were added before AWS assigned a [security group rule unique ID](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/security-group-rules.html), and they do not work well in all scenarios using the`description` and `tags` attributes, which rely on the unique ID.
 * The `aws.vpc.SecurityGroupIngressRule` resource has been added to address these limitations and should be used for all new security group rules.
 * You should not use the `aws.vpc.SecurityGroupIngressRule` resource in conjunction with an `aws.ec2.SecurityGroup` resource with in-line rules or with `aws.ec2.SecurityGroupRule` resources defined for the same Security Group, as rule conflicts may occur and rules will be overwritten.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.SecurityGroup;
 * import com.pulumi.aws.ec2.SecurityGroupArgs;
 * import com.pulumi.aws.vpc.SecurityGroupIngressRule;
 * import com.pulumi.aws.vpc.SecurityGroupIngressRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSecurityGroup = new SecurityGroup("exampleSecurityGroup", SecurityGroupArgs.builder()
 *             .description("example")
 *             .vpcId(aws_vpc.main().id())
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *         var exampleSecurityGroupIngressRule = new SecurityGroupIngressRule("exampleSecurityGroupIngressRule", SecurityGroupIngressRuleArgs.builder()
 *             .securityGroupId(exampleSecurityGroup.id())
 *             .cidrIpv4("10.0.0.0/8")
 *             .fromPort(80)
 *             .ipProtocol("tcp")
 *             .toPort(80)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import security group ingress rules using the `security_group_rule_id`. For example:
 * ```sh
 *  $ pulumi import aws:vpc/securityGroupIngressRule:SecurityGroupIngressRule example sgr-02108b27edd666983
 * ```
 * @property cidrIpv4 The source IPv4 CIDR range.
 * @property cidrIpv6 The source IPv6 CIDR range.
 * @property description The security group rule description.
 * @property fromPort The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
 * @property ipProtocol The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
 * @property prefixListId The ID of the source prefix list.
 * @property referencedSecurityGroupId The source security group that is referenced in the rule.
 * @property securityGroupId The ID of the security group.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property toPort The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
 */
public data class SecurityGroupIngressRuleArgs(
    public val cidrIpv4: Output<String>? = null,
    public val cidrIpv6: Output<String>? = null,
    public val description: Output<String>? = null,
    public val fromPort: Output<Int>? = null,
    public val ipProtocol: Output<String>? = null,
    public val prefixListId: Output<String>? = null,
    public val referencedSecurityGroupId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val toPort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.vpc.SecurityGroupIngressRuleArgs> {
    override fun toJava(): com.pulumi.aws.vpc.SecurityGroupIngressRuleArgs =
        com.pulumi.aws.vpc.SecurityGroupIngressRuleArgs.builder()
            .cidrIpv4(cidrIpv4?.applyValue({ args0 -> args0 }))
            .cidrIpv6(cidrIpv6?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fromPort(fromPort?.applyValue({ args0 -> args0 }))
            .ipProtocol(ipProtocol?.applyValue({ args0 -> args0 }))
            .prefixListId(prefixListId?.applyValue({ args0 -> args0 }))
            .referencedSecurityGroupId(referencedSecurityGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .toPort(toPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityGroupIngressRuleArgs].
 */
@PulumiTagMarker
public class SecurityGroupIngressRuleArgsBuilder internal constructor() {
    private var cidrIpv4: Output<String>? = null

    private var cidrIpv6: Output<String>? = null

    private var description: Output<String>? = null

    private var fromPort: Output<Int>? = null

    private var ipProtocol: Output<String>? = null

    private var prefixListId: Output<String>? = null

    private var referencedSecurityGroupId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var toPort: Output<Int>? = null

    /**
     * @param value The source IPv4 CIDR range.
     */
    @JvmName("dekfphkyvuehkinc")
    public suspend fun cidrIpv4(`value`: Output<String>) {
        this.cidrIpv4 = value
    }

    /**
     * @param value The source IPv6 CIDR range.
     */
    @JvmName("dlfeobvartrjrite")
    public suspend fun cidrIpv6(`value`: Output<String>) {
        this.cidrIpv6 = value
    }

    /**
     * @param value The security group rule description.
     */
    @JvmName("oquosnbyfngvegmn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
     */
    @JvmName("vhemohcnuucopert")
    public suspend fun fromPort(`value`: Output<Int>) {
        this.fromPort = value
    }

    /**
     * @param value The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
     */
    @JvmName("bbdtjpqwjtnwhlfe")
    public suspend fun ipProtocol(`value`: Output<String>) {
        this.ipProtocol = value
    }

    /**
     * @param value The ID of the source prefix list.
     */
    @JvmName("jaxpuifauiohahvk")
    public suspend fun prefixListId(`value`: Output<String>) {
        this.prefixListId = value
    }

    /**
     * @param value The source security group that is referenced in the rule.
     */
    @JvmName("ropysdrxfvlamxqc")
    public suspend fun referencedSecurityGroupId(`value`: Output<String>) {
        this.referencedSecurityGroupId = value
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("uqisaxhhasmhhena")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ytharoukbolmbtmg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     */
    @JvmName("slhvhsdcbdytcxfe")
    public suspend fun toPort(`value`: Output<Int>) {
        this.toPort = value
    }

    /**
     * @param value The source IPv4 CIDR range.
     */
    @JvmName("ectnyhllavmupwnn")
    public suspend fun cidrIpv4(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrIpv4 = mapped
    }

    /**
     * @param value The source IPv6 CIDR range.
     */
    @JvmName("genojmobxvnhcnec")
    public suspend fun cidrIpv6(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrIpv6 = mapped
    }

    /**
     * @param value The security group rule description.
     */
    @JvmName("uoioftotrbvqbxql")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type.
     */
    @JvmName("dghifuphgingeeub")
    public suspend fun fromPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fromPort = mapped
    }

    /**
     * @param value The IP protocol name or number. Use `-1` to specify all protocols. Note that if `ip_protocol` is set to `-1`, it translates to all protocols, all port ranges, and `from_port` and `to_port` values should not be defined.
     */
    @JvmName("fcbsqpkdvimpuiwq")
    public suspend fun ipProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipProtocol = mapped
    }

    /**
     * @param value The ID of the source prefix list.
     */
    @JvmName("wbokgianulwbaips")
    public suspend fun prefixListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixListId = mapped
    }

    /**
     * @param value The source security group that is referenced in the rule.
     */
    @JvmName("mfrmnlqbpuuasofy")
    public suspend fun referencedSecurityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referencedSecurityGroupId = mapped
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("tudcedssyesaqmyy")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qiqywgttybutfoko")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yaseplulcsvotrph")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     */
    @JvmName("srfqyykghaxqibag")
    public suspend fun toPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.toPort = mapped
    }

    internal fun build(): SecurityGroupIngressRuleArgs = SecurityGroupIngressRuleArgs(
        cidrIpv4 = cidrIpv4,
        cidrIpv6 = cidrIpv6,
        description = description,
        fromPort = fromPort,
        ipProtocol = ipProtocol,
        prefixListId = prefixListId,
        referencedSecurityGroupId = referencedSecurityGroupId,
        securityGroupId = securityGroupId,
        tags = tags,
        toPort = toPort,
    )
}
