@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AccessLogSubscription].
 */
@PulumiTagMarker
public class AccessLogSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessLogSubscriptionArgs = AccessLogSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessLogSubscriptionArgsBuilder.() -> Unit) {
        val builder = AccessLogSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AccessLogSubscription {
        val builtJavaResource = com.pulumi.aws.vpclattice.AccessLogSubscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessLogSubscription(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS VPC Lattice Service Network or Service Access log subscription.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.vpclattice.AccessLogSubscription;
 * import com.pulumi.aws.vpclattice.AccessLogSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccessLogSubscription("example", AccessLogSubscriptionArgs.builder()
 *             .resourceIdentifier(aws_vpclattice_service_network.example().id())
 *             .destinationArn(aws_s3.bucket().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC Lattice Access Log Subscription using the access log subscription ID. For example:
 * ```sh
 *  $ pulumi import aws:vpclattice/accessLogSubscription:AccessLogSubscription example rft-8012925589
 * ```
 *
 */
public class AccessLogSubscription internal constructor(
    override val javaResource: com.pulumi.aws.vpclattice.AccessLogSubscription,
) : KotlinCustomResource(javaResource, AccessLogSubscriptionMapper) {
    /**
     * Amazon Resource Name (ARN) of the access log subscription.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the log destination.
     */
    public val destinationArn: Output<String>
        get() = javaResource.destinationArn().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the service network or service.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * The ID or Amazon Resource Identifier (ARN) of the service network or service. You must use the ARN if the resources specified in the operation are in different accounts.
     */
    public val resourceIdentifier: Output<String>
        get() = javaResource.resourceIdentifier().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AccessLogSubscriptionMapper : ResourceMapper<AccessLogSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.vpclattice.AccessLogSubscription::class == javaResource::class

    override fun map(javaResource: Resource): AccessLogSubscription =
        AccessLogSubscription(javaResource as com.pulumi.aws.vpclattice.AccessLogSubscription)
}

/**
 * @see [AccessLogSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessLogSubscription].
 */
public suspend fun accessLogSubscription(
    name: String,
    block: suspend AccessLogSubscriptionResourceBuilder.() -> Unit,
): AccessLogSubscription {
    val builder = AccessLogSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessLogSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessLogSubscription(name: String): AccessLogSubscription {
    val builder = AccessLogSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
